//
//  KillViewController.m
//  ASR033W
//
//  Created by mac on 2020/12/11.
//

#import "KillViewController.h"
#import <ASR033WSDK/ASR033WSDK.h>
#import <SVProgressHUD/SVProgressHUD.h>
#import "Utils.h"
#import "System.h"

@interface KillViewController ()<ASR033WDelegate, UITextFieldDelegate>
@property (strong, nonatomic) IBOutlet UITextField *matchTextField;
@property (strong, nonatomic) IBOutlet UITextField *passwordTextField;
@end

@implementation KillViewController
{
    ASR033W *asr033w;
    ASR033WMemoryBank memoryBankType;
    System *system;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    self.matchTextField.text = _epcData.epc;
    system = [System sharedSystem];
    asr033w = [ASR033W sharedInstance];
    memoryBankType = ASR033WMemoryBank_EPC;
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:YES];
    asr033w.delegate = self;
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:YES];
    asr033w.delegate = nil;
}
#pragma mark - Action
- (IBAction)onClickKillButton:(UIBarButtonItem *)sender {
    [self.view endEditing:YES];
    if ([self.passwordTextField.text isEqualToString:@""]) {
        [Utils showAlert:@"Error" message:@"Please enter your password"];
        return;
    }
    NSString *password = @"00000000";
    if (self.passwordTextField.text.length > 0) {
        if (self.passwordTextField.text.length != 8) {
            [Utils showAlert:@"Error" message:@"Please enter your eight-digit password"];
            return;
        } else {
            password = self.passwordTextField.text;
        }
    }
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"Kill?" message:nil preferredStyle:UIAlertControllerStyleAlert];
    UIAlertAction *ok = [UIAlertAction actionWithTitle:@"OK" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [self performSelector:@selector(dismissHUD) withObject:nil afterDelay:10];
        [SVProgressHUD show];
        NSData *epcs = [self.matchTextField.text hexStringToBytes];
        [self->asr033w killMemory:epcs password:[Utils getDecimal:password] antenna1:[self->system getAnt1Status] antenna2:[self->system getAnt2Status] antenna3:[self->system getAnt3Status] antenna4:[self->system getAnt4Status] antenna5:[self->system getAnt5Status] antenna6:[self->system getAnt6Status] antenna7:[self->system getAnt7Status] antenna8:[self->system getAnt8Status]];
    }];
    UIAlertAction *cancel = [UIAlertAction actionWithTitle:@"Cancel" style:UIAlertActionStyleCancel handler:nil];
    [alert addAction:ok];
    [alert addAction:cancel];
    [self presentViewController:alert animated:YES completion:nil];
}
#pragma mark - UITextField delegate
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    if (textField == self.passwordTextField) {
        if ([Utils isCorrectWriteData:[textField.text stringByAppendingString:string]]) {
            return YES;
        } else {
            return NO;
        }
    }
    return YES;
}
#pragma mark - ASR033WDelegate
- (void)receivedASR033WNetworkState:(ASR033WNetworkState)state error:(NSError *)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (state != ASR033WNetworkStateConnected) {
            [self.navigationController popToRootViewControllerAnimated:YES];
        }
    }];
}
- (void)receivedASR033WDeviceState:(ASR033WResultCode)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (error != ASR033WResultNoError) {
            [Utils showAlert:@"Error" message:@"Failed to get response. Try again."];
        }
    }];
}
- (void)receivedASR033WActionState:(ASR033WCommandType)action resultCode:(ASR033WResultCode)resultCode {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(dismissHUD) object:nil];
        [SVProgressHUD dismiss];
        if (action == ASR033WCommandKill) {
            if (resultCode == ASR033WResultNoError) {
                [Utils showAlert:@"" message:@"Success"];
            } else {
                [Utils showAlert:@"Error" message:[self->asr033w getMessageWithASR033WResultCode:resultCode]];
            }
        } else {
            [Utils showAlert:@"Error" message:[self->asr033w getMessageWithASR033WResultCode:ASR033WResultOtherError]];
        }
    }];
}
- (void)accessASR033WResult:(ASR033WResultCode)error actionState:(ASR033WCommandType)action epc:(NSString *)epc data:(NSString *)data rssi:(float)rssi phase:(float)phase frequency:(float)frequency {
    
}
#pragma mark - System
- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event {
    [self.view endEditing:YES];
}
#pragma mark - Private
- (void)viewBack {
    [self.view endEditing:YES];
}
- (void)dismissHUD {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        [SVProgressHUD dismiss];
    }];
}
@end
