//
//  DataListController.m
//  ASR033W
//
//  Created by mac on 2020/12/8.
//

#import "DataListController.h"
#import "ReadViewController.h"
#import "WriteViewController.h"
#import "LockViewController.h"
#import "KillViewController.h"
#import <ASR033WSDK/ASR033WSDK.h>

@interface DataListController ()<ASR033WDelegate>

@end

@implementation DataListController
{
    ASR033W *asr033w;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    self.tableView.tableFooterView = [[UIView alloc] initWithFrame:CGRectZero];
    asr033w = [ASR033W sharedInstance];
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:YES];
    asr033w.delegate = self;
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:YES];
    asr033w.delegate = nil;
}
#pragma mark - UITableViewDelegate
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row == 0) {
        [self performSegueWithIdentifier:@"ReadID" sender:nil];
    } else if (indexPath.row == 1) {
        [self performSegueWithIdentifier:@"WriteID" sender:nil];
    } else if (indexPath.row == 2) {
        [self performSegueWithIdentifier:@"LockID" sender:nil];
    } else if (indexPath.row == 3) {
        [self performSegueWithIdentifier:@"KillID" sender:nil];
    }
}
#pragma mark - ASR033WDelegate
- (void)ASR033W:(ASR033W *)ASR033W changeNetworkState:(ASR033WNetworkState)state error:(NSError *)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (state != ASR033WNetworkStateConnected) {
            [self.navigationController popToRootViewControllerAnimated:YES];
        }
    }];
}
#pragma mark - Navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    if ([segue.identifier isEqualToString:@"ReadID"]) {
        ReadViewController *readVC = segue.destinationViewController;
        readVC.epcData = _epcData;
    } else if ([segue.identifier isEqualToString:@"WriteID"]) {
        WriteViewController *customVC = segue.destinationViewController;
        customVC.epcData = _epcData;
    } else if ([segue.identifier isEqualToString:@"LockID"]) {
        LockViewController *customVC = segue.destinationViewController;
        customVC.epcData = _epcData;
    } else if ([segue.identifier isEqualToString:@"KillID"]) {
        KillViewController *customVC = segue.destinationViewController;
        customVC.epcData = _epcData;
    }
}
@end
