//
//  RFIDSettingViewController.m
//  ASR033W
//
//  Created by mac on 2020/11/30.
//

#import "RFIDSettingViewController.h"
#import <ASR033WSDK/ASR033WSDK.h>
#import "SysSwitchCell.h"
#import "TextFieldCell.h"
#import "System.h"
#import <SVProgressHUD/SVProgressHUD.h>
#import "Utils.h"

@interface RFIDSettingViewController ()<ASR033WDelegate, SysSwitchCellDelegate>
@property (weak, nonatomic) IBOutlet UITableView *tableView;
@property (weak, nonatomic) IBOutlet UITableViewCell *lbtTableViewCell;
@end

@implementation RFIDSettingViewController
{
    ASR033W *asr033w;
    System *system;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    system = [System sharedSystem];
    asr033w = [ASR033W sharedInstance];
    self.tableView.tableFooterView = [[UIView alloc] initWithFrame:CGRectZero];
    self.tableView.sectionHeaderHeight = 0;
    NSString *regionName = [asr033w regionName];
    if (![regionName hasPrefix:@"Japan("]) {
        self.lbtTableViewCell.hidden = YES;
    } else {
        self.lbtTableViewCell.hidden = NO;
    }
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:YES];
    asr033w.delegate = self;
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:YES];
    asr033w.delegate = nil;
}
- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:YES];
}
#pragma mark - ASR033WDelegate
- (void)receivedASR033WNetworkState:(ASR033WNetworkState)state error:(NSError *)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (state != ASR033WNetworkStateConnected) {
            [self.navigationController popToRootViewControllerAnimated:YES];
        }
    }];
}
- (void)receivedASR033WDeviceState:(ASR033WResultCode)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (error != ASR033WResultNoError) {
            [Utils showAlert:@"Error" message:@"Failed to get response. Try again."];
        }
    }];
}
@end
