//
//  LbtListViewController.m
//  ASR033W
//
//  Created by mac on 2020/11/26.
//

#import "LbtListViewController.h"
#import <ASR033WSDK/ASR033WSDK.h>
#import <SVProgressHUD/SVProgressHUD.h>
#import "System.h"
#import "Utils.h"

@interface LbtListViewController ()<ASR033WDelegate, UITableViewDelegate, UITableViewDataSource>
@property (strong, nonatomic) IBOutlet UITableView *tableView;
@end

@implementation LbtListViewController{
    ASR033W *asr033w;
    NSArray *array;
    System *system;
    NSMutableArray *lbtArray;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    array = [[NSArray alloc] init];
    system = [System sharedSystem];
    asr033w = [ASR033W sharedInstance];
    self.tableView.tableFooterView = [[UIView alloc] initWithFrame:CGRectZero];
    self.tableView.allowsMultipleSelection = YES;
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:YES];
    asr033w.delegate = self;
    [self performSelector:@selector(dismissHUD) withObject:nil afterDelay:10];
    [SVProgressHUD showWithStatus:@"LBT Channel"];
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:YES];
    asr033w.delegate = nil;
}
- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:YES];
    array = [asr033w getLBTMask];
    lbtArray = [NSMutableArray arrayWithArray:[asr033w getLBT]];
    [self.tableView reloadData];
    [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(dismissHUD) object:nil];
    [SVProgressHUD dismiss];
}
#pragma mark - Action
- (IBAction)onClickDoneBarItem:(UIBarButtonItem *)sender {
    [self.tableView endEditing:YES];
    [self performSelector:@selector(dismissHUD) withObject:nil afterDelay:10];
    [SVProgressHUD showWithStatus:@"Set Lbt Channel"];
    ASR033WResultCode code = [asr033w setLBT:lbtArray];
    if (code == ASR033WResultNoError) {
        [Utils showAlert:@"" message:@"Success"];
    } else {
        [Utils showAlert:@"" message:@"Fail"];
    }
    [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(dismissHUD) object:nil];
    [SVProgressHUD dismiss];
}
#pragma mark - Table view data source
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return array.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"tableViewCell"];
    if (!cell){
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:@"tableViewCell"];
    }
    NSString *string = [array objectAtIndex:indexPath.row];
    cell.textLabel.text = string;
    if ([lbtArray containsObject:[NSString stringWithFormat:@"%ld", indexPath.row]]) {
        cell.accessoryType = UITableViewCellAccessoryCheckmark;
    } else {
        cell.accessoryType = UITableViewCellAccessoryNone;
    }
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    return cell;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    NSString * select = [NSString stringWithFormat:@"%ld", indexPath.row];
    if ([lbtArray containsObject:select]) {
        [lbtArray removeObject:select];
    } else {
        [lbtArray addObject:select];
    }
    [self.tableView reloadData];
}
#pragma mark - ASR033WDelegate
- (void)receivedASR033WNetworkState:(ASR033WNetworkState)state error:(NSError *)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (state != ASR033WNetworkStateConnected) {
            [self.navigationController popToRootViewControllerAnimated:YES];
        }
    }];
}
- (void)receivedASR033WDeviceState:(ASR033WResultCode)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (error != ASR033WResultNoError) {
            [Utils showAlert:@"Error" message:@"Failed to get response. Try again."];
        }
    }];
}
#pragma mark - Private
- (void)dismissHUD {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        [SVProgressHUD dismiss];
    }];
}
@end
