//
//  InventoryViewController.m
//  ASR033W
//
//  Created by mac on 2020/11/26.
//

#import "InventoryViewController.h"
#import <ASR033WSDK/ASR033WSDK.h>
#import "SysSwitchCell.h"
#import "System.h"
#import <SVProgressHUD/SVProgressHUD.h>
#import "Utils.h"

@interface InventoryViewController ()<ASR033WDelegate, SysSwitchCellDelegate, UITableViewDelegate, UITableViewDataSource>
@property (strong, nonatomic) IBOutlet UITableView *tableView;
@end

@implementation InventoryViewController{
    ASR033W *asr033w;
    System *system;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    system = [System sharedSystem];
    asr033w = [ASR033W sharedInstance];
    self.tableView.tableFooterView = [[UIView alloc] initWithFrame:CGRectZero];
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:YES];
    asr033w.delegate = self;
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:YES];
    asr033w.delegate = nil;
}

#pragma mark - Table view data source
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return 2;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == 0) {
        NSString *cellIdentifier = @"tableViewCell";
        UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
        if(!cell){
            cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:cellIdentifier];
        }
        cell.textLabel.text = @"Antennas Select";
        cell.textLabel.textAlignment = NSTextAlignmentLeft;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        return cell;
    } else if (indexPath.row == 1) {
        NSString *cellIdentifier = @"SysSwitchCell";
        SysSwitchCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
        if(!cell) {
            cell = [[[NSBundle mainBundle] loadNibNamed:@"SysSwitchCell" owner:self options:nil] firstObject];
        }
        cell.delegate = self;
        cell.titleLabel.text = @"TID";
        cell.tag = 10000;
        cell.sysSwitch.on = [system getTid];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.accessoryType = UITableViewCellAccessoryNone;
        return cell;
    } else {
        return nil;
    }
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row == 0) {
        [self performSegueWithIdentifier:@"AntennasSelectID" sender:nil];
    }
}
#pragma mark - SwitchDelegate
- (void)whenClickSysSwitch:(UISwitch *)cell {
    [self performSelector:@selector(dismissHUD) withObject:nil afterDelay:10];
    [SVProgressHUD show];
    SysSwitchCell *sysCell = (SysSwitchCell *)cell;
    if (sysCell.tag == 10000) {
        [system setTid:sysCell.sysSwitch.isOn];
    }
    [self.tableView reloadData];
    [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(dismissHUD) object:nil];
    [SVProgressHUD dismiss];
}
#pragma mark - ASR033WDelegate
- (void)receivedASR033WNetworkState:(ASR033WNetworkState)state error:(NSError *)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (state != ASR033WNetworkStateConnected) {
            [self.navigationController popToRootViewControllerAnimated:YES];
        }
    }];
}
- (void)receivedASR033WDeviceState:(ASR033WResultCode)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (error != ASR033WResultNoError) {
            [Utils showAlert:@"Error" message:@"Failed to get response. Try again."];
        }
    }];
}
#pragma mark - Private
- (void)dismissHUD {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        [SVProgressHUD dismiss];
    }];
}
@end
