//
//  IdleTimeViewController.m
//  ASR033WDemo
//
//  Created by Songxueqian on 2024/11/18.
//

#import "IdleTimeViewController.h"
#import <ASR033WSDK/ASR033WSDK.h>
#import <SVProgressHUD/SVProgressHUD.h>
#import "System.h"
#import "Utils.h"

@interface IdleTimeViewController ()<ASR033WDelegate, UITextFieldDelegate>
@property (strong, nonatomic) IBOutlet UITextField *textField;
@end

@implementation IdleTimeViewController{
    ASR033W *asr033w;
    int idleTime;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    asr033w = [ASR033W sharedInstance];
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:YES];
    asr033w.delegate = self;
    [self performSelector:@selector(dismissHUD) withObject:nil afterDelay:10];
    [SVProgressHUD showWithStatus:@"Idle time"];
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:YES];
    asr033w.delegate = nil;
}
- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:YES];
    idleTime = [asr033w getIdleTime];
    self.textField.text = [NSString stringWithFormat:@"%d", idleTime];
    [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(dismissHUD) object:nil];
    [SVProgressHUD dismiss];
}
#pragma mark - Action
- (IBAction)onClickDoneBarItem:(UIBarButtonItem *)sender {
    [self.view endEditing:YES];
    [self performSelector:@selector(dismissHUD) withObject:nil afterDelay:10];
    [SVProgressHUD showWithStatus:@"Set Idle time"];
    ASR033WResultCode code = [asr033w setIdleTime:idleTime];
    if (code == ASR033WResultNoError) {
        [Utils showAlert:@"" message:@"Success"];
    } else {
        [Utils showAlert:@"" message:@"Fail"];
    }
    [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(dismissHUD) object:nil];
    [SVProgressHUD dismiss];
}
#pragma mark - ASR033WDelegate
- (void)receivedASR033WNetworkState:(ASR033WNetworkState)state error:(NSError *)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (state != ASR033WNetworkStateConnected) {
            [self.navigationController popToRootViewControllerAnimated:YES];
        }
    }];
}
- (void)receivedASR033WDeviceState:(ASR033WResultCode)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (error != ASR033WResultNoError) {
            [Utils showAlert:@"Error" message:@"Failed to get response. Try again."];
        }
    }];
}
#pragma mark - UITextFieldDelegate
- (void)textFieldDidEndEditing:(UITextField *)textField {
    idleTime = [self.textField.text intValue];
}
- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    [self.textField resignFirstResponder];
    return YES;
}
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string {
    if ([[textField.text stringByAppendingString:string] intValue] >= 0 && [[textField.text stringByAppendingString:string] intValue] <= 65535) {
        return YES;
    } else {
        return NO;
    }
}
#pragma mark - System
- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event {
    [self.view endEditing:YES];
}
#pragma mark - Private
- (void)dismissHUD {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        [SVProgressHUD dismiss];
    }];
}
@end
