//
//  AntennaViewController.m
//  ASR033W
//
//  Created by mac on 2020/10/30.
//

#import "AntennaViewController.h"
#import <ASR033WSDK/ASR033WSDK.h>
#import "System.h"

@interface AntennaViewController ()<ASR033WDelegate, UITableViewDelegate, UITableViewDataSource>
@property (strong, nonatomic) IBOutlet UITableView *tableView;
@end

@implementation AntennaViewController
{
    ASR033W *asr033w;
    NSArray *array;
    System *system;
    BOOL allSelected;
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:YES];
    asr033w.delegate = self;
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:YES];
    asr033w.delegate = nil;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    system = [System sharedSystem];
    asr033w = [ASR033W sharedInstance];
    self.tableView.tableFooterView = [[UIView alloc] initWithFrame:CGRectZero];
    if ([system getAnt1Status] && [system getAnt2Status] && [system getAnt3Status] && [system getAnt4Status] && [system getAnt5Status] && [system getAnt6Status] && [system getAnt7Status] && [system getAnt8Status]) {
        allSelected = YES;
    } else {
        allSelected = NO;
    }
    [self getData];
}
#pragma mark - Action
- (IBAction)onClickAllBarButtonItem:(UIBarButtonItem *)sender {
    if (allSelected) {
        allSelected = NO;
        [self setAntStatus:NO];
    } else {
        allSelected = YES;
        [self setAntStatus:YES];
    }
    [self getData];
    [self.tableView reloadData];
}
#pragma mark - Table view data source
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return array.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"tableViewCell"];
    if (!cell){
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:@"tableViewCell"];
    }
    NSDictionary *dic = [array objectAtIndex:indexPath.row];
    cell.textLabel.text = [[dic allKeys] firstObject];
    if ([[dic valueForKey:[[dic allKeys] firstObject]] boolValue]) {
        cell.accessoryType = UITableViewCellAccessoryCheckmark;
    } else {
        cell.accessoryType = UITableViewCellAccessoryNone;
    }
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    return cell;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    NSDictionary *dic = [array objectAtIndex:indexPath.row];
    BOOL status = [[dic valueForKey:[[dic allKeys] firstObject]] boolValue];
    switch (indexPath.row) {
        case 0:
            if (status) {
                [system setAnt1Status:NO];
            } else {
                [system setAnt1Status:YES];
            }
            break;
        case 1:
            if (status) {
                [system setAnt2Status:NO];
            } else {
                [system setAnt2Status:YES];
            }
            break;
        case 2:
            if (status) {
                [system setAnt3Status:NO];
            } else {
                [system setAnt3Status:YES];
            }
            break;
        case 3:
            if (status) {
                [system setAnt4Status:NO];
            } else {
                [system setAnt4Status:YES];
            }
            break;
        case 4:
            if (status) {
                [system setAnt5Status:NO];
            } else {
                [system setAnt5Status:YES];
            }
            break;
        case 5:
            if (status) {
                [system setAnt6Status:NO];
            } else {
                [system setAnt6Status:YES];
            }
            break;
        case 6:
            if (status) {
                [system setAnt7Status:NO];
            } else {
                [system setAnt7Status:YES];
            }
            break;
        case 7:
            if (status) {
                [system setAnt8Status:NO];
            } else {
                [system setAnt8Status:YES];
            }
            break;
        default:
            break;
    }
    [self getData];
    [self.tableView reloadData];
}
#pragma mark - Private
- (void)getData {
    NSDictionary *dic1 = [NSDictionary dictionaryWithObject:[NSString stringWithFormat:@"%d", [system getAnt1Status]] forKey:@"Antenna1"];
    NSDictionary *dic2 = [NSDictionary dictionaryWithObject:[NSString stringWithFormat:@"%d", [system getAnt2Status]] forKey:@"Antenna2"];
    NSDictionary *dic3 = [NSDictionary dictionaryWithObject:[NSString stringWithFormat:@"%d", [system getAnt3Status]] forKey:@"Antenna3"];
    NSDictionary *dic4 = [NSDictionary dictionaryWithObject:[NSString stringWithFormat:@"%d", [system getAnt4Status]] forKey:@"Antenna4"];
    NSDictionary *dic5 = [NSDictionary dictionaryWithObject:[NSString stringWithFormat:@"%d", [system getAnt5Status]] forKey:@"Antenna5"];
    NSDictionary *dic6 = [NSDictionary dictionaryWithObject:[NSString stringWithFormat:@"%d", [system getAnt6Status]] forKey:@"Antenna6"];
    NSDictionary *dic7 = [NSDictionary dictionaryWithObject:[NSString stringWithFormat:@"%d", [system getAnt7Status]] forKey:@"Antenna7"];
    NSDictionary *dic8 = [NSDictionary dictionaryWithObject:[NSString stringWithFormat:@"%d", [system getAnt8Status]] forKey:@"Antenna8"];
    array = [NSArray arrayWithObjects:dic1, dic2, dic3, dic4, dic5, dic6, dic7, dic8, nil];
}
- (void)setAntStatus:(BOOL)status {
    [system setAnt1Status:status];
    [system setAnt2Status:status];
    [system setAnt3Status:status];
    [system setAnt4Status:status];
    [system setAnt5Status:status];
    [system setAnt6Status:status];
    [system setAnt7Status:status];
    [system setAnt8Status:status];
}
#pragma mark - ASR033WDelegate
- (void)receivedASR033WNetworkState:(ASR033WNetworkState)state error:(NSError *)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (state != ASR033WNetworkStateConnected) {
            [self.navigationController popToRootViewControllerAnimated:YES];
        }
    }];
}
@end
