//
//  AntPowerViewController.m
//  ASR033W
//
//  Created by mac on 2020/11/25.
//

#import "AntPowerViewController.h"
#import <SVProgressHUD/SVProgressHUD.h>
#import <ASR033WSDK/ASR033WSDK.h>
#import "System.h"
#import "Utils.h"
@interface AntPowerViewController ()<UITextFieldDelegate, ASR033WDelegate>
@property (strong, nonatomic) IBOutlet UITextField *ant1TextField;
@property (strong, nonatomic) IBOutlet UITextField *ant2TextField;
@property (strong, nonatomic) IBOutlet UITextField *ant3TextField;
@property (strong, nonatomic) IBOutlet UITextField *ant4TextField;
@property (strong, nonatomic) IBOutlet UITextField *ant5TextField;
@property (strong, nonatomic) IBOutlet UITextField *ant6TextField;
@property (strong, nonatomic) IBOutlet UITextField *ant7TextField;
@property (strong, nonatomic) IBOutlet UITextField *ant8TextField;
@end

@implementation AntPowerViewController
{
    ASR033W *asr033w;
    System *system;
    int ant1Power;
    int ant2Power;
    int ant3Power;
    int ant4Power;
    int ant5Power;
    int ant6Power;
    int ant7Power;
    int ant8Power;
    int powerMax;
    int powerMin;
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:YES];
    asr033w.delegate = self;
    [self performSelector:@selector(dismissHUD) withObject:nil afterDelay:10];
    [SVProgressHUD showWithStatus:@"Antenna power"];
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:YES];
    asr033w.delegate = nil;
}
- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:YES];
    NSDictionary * powerDic = [asr033w getAntennaPower];
    self.ant1TextField.text = [NSString stringWithFormat:@"%@", [powerDic valueForKey:@"Antenna1Power"]];
    self.ant2TextField.text = [NSString stringWithFormat:@"%@", [powerDic valueForKey:@"Antenna2Power"]];
    self.ant3TextField.text = [NSString stringWithFormat:@"%@", [powerDic valueForKey:@"Antenna3Power"]];
    self.ant4TextField.text = [NSString stringWithFormat:@"%@", [powerDic valueForKey:@"Antenna4Power"]];
    self.ant5TextField.text = [NSString stringWithFormat:@"%@", [powerDic valueForKey:@"Antenna5Power"]];
    self.ant6TextField.text = [NSString stringWithFormat:@"%@", [powerDic valueForKey:@"Antenna6Power"]];
    self.ant7TextField.text = [NSString stringWithFormat:@"%@", [powerDic valueForKey:@"Antenna7Power"]];
    self.ant8TextField.text = [NSString stringWithFormat:@"%@", [powerDic valueForKey:@"Antenna8Power"]];
    ant1Power = [[powerDic valueForKey:@"Antenna1Power"] intValue];
    ant2Power = [[powerDic valueForKey:@"Antenna2Power"] intValue];
    ant3Power = [[powerDic valueForKey:@"Antenna3Power"] intValue];
    ant4Power = [[powerDic valueForKey:@"Antenna4Power"] intValue];
    ant5Power = [[powerDic valueForKey:@"Antenna5Power"] intValue];
    ant6Power = [[powerDic valueForKey:@"Antenna6Power"] intValue];
    ant7Power = [[powerDic valueForKey:@"Antenna7Power"] intValue];
    ant8Power = [[powerDic valueForKey:@"Antenna8Power"] intValue];
    NSDictionary *powerRangeDic = [asr033w getAntennaPowerRange];
    powerMax = [[powerRangeDic valueForKey:@"Max"] intValue];
    powerMin = [[powerRangeDic valueForKey:@"Min"] intValue];
    self.ant1TextField.placeholder = [NSString stringWithFormat:@"%d~%d", powerMin, powerMax];
    self.ant2TextField.placeholder = [NSString stringWithFormat:@"%d~%d", powerMin, powerMax];
    self.ant3TextField.placeholder = [NSString stringWithFormat:@"%d~%d", powerMin, powerMax];
    self.ant4TextField.placeholder = [NSString stringWithFormat:@"%d~%d", powerMin, powerMax];
    self.ant5TextField.placeholder = [NSString stringWithFormat:@"%d~%d", powerMin, powerMax];
    self.ant6TextField.placeholder = [NSString stringWithFormat:@"%d~%d", powerMin, powerMax];
    self.ant7TextField.placeholder = [NSString stringWithFormat:@"%d~%d", powerMin, powerMax];
    self.ant8TextField.placeholder = [NSString stringWithFormat:@"%d~%d", powerMin, powerMax];
    [self.tableView reloadData];
    [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(dismissHUD) object:nil];
    [SVProgressHUD dismiss];
}
- (void)viewDidLoad {
    [super viewDidLoad];
    system = [System sharedSystem];
    asr033w = [ASR033W sharedInstance];
    self.tableView.tableFooterView = [[UIView alloc] initWithFrame:CGRectZero];
}
#pragma mark - Action
- (IBAction)onClickDoneBarItem:(UIBarButtonItem *)sender {
    [self.tableView endEditing:YES];
    if (ant1Power < powerMin || ant1Power > powerMax) {
        [Utils showAlert:@"Fail" message:[NSString stringWithFormat:@"Antenna1 Power %d~%d", powerMin, powerMax]];
        return;
    }
    if (ant2Power < powerMin || ant2Power > powerMax) {
        [Utils showAlert:@"Fail" message:[NSString stringWithFormat:@"Antenna2 Power %d~%d", powerMin, powerMax]];
        return;
    }
    if (ant3Power < powerMin || ant3Power > powerMax) {
        [Utils showAlert:@"Fail" message:[NSString stringWithFormat:@"Antenna3 Power %d~%d", powerMin, powerMax]];
        return;
    }
    if (ant4Power < powerMin || ant4Power > powerMax) {
        [Utils showAlert:@"Fail" message:[NSString stringWithFormat:@"Antenna4 Power %d~%d", powerMin, powerMax]];
        return;
    }
    if (ant5Power < powerMin || ant5Power > powerMax) {
        [Utils showAlert:@"Fail" message:[NSString stringWithFormat:@"Antenna5 Power %d~%d", powerMin, powerMax]];
        return;
    }
    if (ant6Power < powerMin || ant6Power > powerMax) {
        [Utils showAlert:@"Fail" message:[NSString stringWithFormat:@"Antenna6 Power %d~%d", powerMin, powerMax]];
        return;
    }
    if (ant7Power < powerMin || ant7Power > powerMax) {
        [Utils showAlert:@"Fail" message:[NSString stringWithFormat:@"Antenna7 Power %d~%d", powerMin, powerMax]];
        return;
    }
    if (ant8Power < powerMin || ant8Power > powerMax) {
        [Utils showAlert:@"Fail" message:[NSString stringWithFormat:@"Antenna8 Power %d~%d", powerMin, powerMax]];
        return;
    }
    [self performSelector:@selector(dismissHUD) withObject:nil afterDelay:10];
    [SVProgressHUD showWithStatus:@"Set antenna power"];
    ASR033WResultCode code = [asr033w setAntenna1Power:ant1Power
                Antenna2Power:ant2Power
                Antenna3Power:ant3Power
                Antenna4Power:ant4Power
                Antenna5Power:ant5Power
                Antenna6Power:ant6Power
                Antenna7Power:ant7Power
                Antenna8Power:ant8Power];
    if (code == ASR033WResultNoError) {
        [Utils showAlert:@"" message:@"Success"];
    } else {
        [Utils showAlert:@"" message:@"Fail"];
    }
    [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(dismissHUD) object:nil];
    [SVProgressHUD dismiss];
}
#pragma mark - UITextFieldDelegate
- (void)textFieldDidEndEditing:(UITextField *)textField {
    if (textField == self.ant1TextField) {
        ant1Power = [self.ant1TextField.text intValue];
    } else if (textField == self.ant2TextField) {
        ant2Power = [self.ant2TextField.text intValue];
    } else if (textField == self.ant3TextField) {
        ant3Power = [self.ant3TextField.text intValue];
    } else if (textField == self.ant4TextField) {
        ant4Power = [self.ant4TextField.text intValue];
    } else if (textField == self.ant5TextField) {
        ant5Power = [self.ant5TextField.text intValue];
    } else if (textField == self.ant6TextField) {
        ant6Power = [self.ant6TextField.text intValue];
    } else if (textField == self.ant7TextField) {
        ant7Power = [self.ant7TextField.text intValue];
    } else if (textField == self.ant8TextField) {
        ant8Power = [self.ant8TextField.text intValue];
    }
}
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string {
    if ([[textField.text stringByAppendingString:string] intValue] >= powerMin && [[textField.text stringByAppendingString:string] intValue] <= powerMax) {
        return YES;
    } else {
        return NO;
    }
}
#pragma mark - UITableViewDelegate
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [self.tableView endEditing:YES];
}
#pragma mark - ASR033WDelegate
- (void)receivedASR033WNetworkState:(ASR033WNetworkState)state error:(NSError *)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (state != ASR033WNetworkStateConnected) {
            [self.navigationController popToRootViewControllerAnimated:YES];
        }
    }];
}
- (void)receivedASR033WDeviceState:(ASR033WResultCode)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (error != ASR033WResultNoError) {
            [Utils showAlert:@"Error" message:@"Failed to get response. Try again."];
        }
    }];
}
#pragma mark - Private
- (void)dismissHUD {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        [SVProgressHUD dismiss];
    }];
}
@end
