//
//  PrintPictureViewController.m
//
//  Created by mac on 2019/3/26.
//  Copyright © 2019年 zyl. All rights reserved.
//

#import "PrintPictureViewController.h"
#import "PrinPicTableViewCell.h"
#import <ASR033WSDK/ASR033WSDK.h>
#import <SVProgressHUD/SVProgressHUD.h>

@interface PrintPictureViewController ()<UITableViewDelegate, UITableViewDataSource, ASR033WDelegate>
@property (nonatomic, strong)NSMutableArray *dataArray;
@end

@implementation PrintPictureViewController{
    UIAlertController *alert;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    self.automaticallyAdjustsScrollViewInsets = NO;
    self.dataArray = [NSMutableArray arrayWithObjects:@"logo", @"test", nil];
    self.navigationItem.rightBarButtonItem = nil;
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:YES];
    [ASR033W sharedInstance].delegate = self;
}

- (nonnull UITableViewCell *)tableView:(nonnull UITableView *)tableView cellForRowAtIndexPath:(nonnull NSIndexPath *)indexPath {
    NSString *cellIdentifier = @"PrintPic";
    PrinPicTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
    if (!cell) {
        cell =  [[NSBundle mainBundle] loadNibNamed:cellIdentifier owner:self options:nil].firstObject;
    }
    cell.logoImage.image = [UIImage imageNamed:[self.dataArray objectAtIndex:indexPath.row]];
    cell.logoImage.contentMode = UIViewContentModeScaleAspectFit;
    [cell setSelectionStyle:UITableViewCellSelectionStyleNone];
    cell.selected = NO;
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    if (self.nameDelegate && [self.nameDelegate respondsToSelector:@selector(backPicName:width:height:)]) {
        NSString *width = @"";
        NSString *height = @"";

        switch (indexPath.row) {
            case 0:
                width = @"200";
                height = @"60";
                break;
            case 1:
                width = @"200";
                height = @"73";
                break;
            default:
                break;
        }
        [self.nameDelegate backPicName:[self.dataArray objectAtIndex:indexPath.row] width:width height:height];
    }
    [self.navigationController popViewControllerAnimated:YES];
}

- (NSInteger)tableView:(nonnull UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArray.count;
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}

- (IBAction)clearAction:(id)sender {
    [self.nameDelegate backPicName:@"Select Image" width:@"" height:@""];
    [self.navigationController popViewControllerAnimated:YES];
}

#pragma mark - ASR033WDelegate
- (void)receivedASR033WNetworkState:(ASR033WNetworkState)state error:(NSError *)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (state != ASR033WNetworkStateConnected) {
            [self.navigationController popToRootViewControllerAnimated:YES];
        }
    }];
}
@end
