//
//  InformationViewController.m
//  P52NDemo
//
//  Created by mac on 2020/11/20.
//

#import "InformationViewController.h"
#import "InformationCell.h"
#import <ASR033WSDK/ASR033WSDK.h>
#import <SVProgressHUD/SVProgressHUD.h>
#import "Utils.h"

@interface InformationViewController ()<UITableViewDelegate, UITableViewDataSource, ASR033WDelegate>
@property (strong, nonatomic) IBOutlet UITableView *tableView;
@end

@implementation InformationViewController{
    NSArray *dataArray;
    NSMutableArray *valueArray;
    ASR033W *asr033w;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    dataArray = [NSArray arrayWithObjects:@"App version:", @"SDK version:", @"Region/Country:", @"RFID module manufacture number:", @"Hardware version:", @"RFID Module version:", @"Firmware version:", @"MAC:", nil];
    valueArray = [[NSMutableArray alloc] init];
    self.tableView.tableFooterView = [[UIView alloc] initWithFrame:CGRectZero];
    asr033w = [ASR033W sharedInstance];
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:YES];
    asr033w.delegate = self;
    [self performSelector:@selector(dismissHUD) withObject:nil afterDelay:10];
    [SVProgressHUD showWithStatus:@"Information"];
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:YES];
    asr033w.delegate = nil;
}
- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:YES];
    NSDictionary *infoDictionary = [[NSBundle mainBundle] infoDictionary];
    NSString *app_Version = [infoDictionary objectForKey:@"CFBundleShortVersionString"];
    NSString *app_Build = [infoDictionary objectForKey:@"CFBundleVersion"];
    NSString *appVersion = [NSString stringWithFormat:@"Version:%@ Build:%@", app_Version, app_Build];
    NSString *sdkVersion = [asr033w getSDKVersion];
    NSString *regionName = [asr033w regionName];
    NSString *serialNumber = [asr033w serialNumber];
    NSString *hardwareVersion = [asr033w hardwareVersion];
    NSString *rFModuleVersion = [asr033w rFModuleVersion];
    NSString *fVersion = [asr033w firmwareVersion];
    NSString *macAddress = [asr033w macAddress];

    NSLog(@"appVersion = %@", appVersion);
    NSLog(@"sdkVersion = %@", sdkVersion);
    NSLog(@"regionName = %@", regionName);
    NSLog(@"serialNumber = %@", serialNumber);
    NSLog(@"hardwareVersion = %@", hardwareVersion);
    NSLog(@"rFModuleVersion = %@", rFModuleVersion);
    NSLog(@"fVersion = %@", fVersion);
    NSLog(@"macAddress = %@", macAddress);

    [valueArray addObject:appVersion];
    [valueArray addObject:sdkVersion];
    [valueArray addObject:regionName];
    [valueArray addObject:serialNumber];
    [valueArray addObject:hardwareVersion];
    [valueArray addObject:rFModuleVersion];
    [valueArray addObject:fVersion];
    [valueArray addObject:macAddress];

    [self.tableView reloadData];
    [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(dismissHUD) object:nil];
    [SVProgressHUD dismiss];
}
#pragma mark - Table view data source
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return valueArray.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    NSString *cellIdentifier = @"InformationCell";
    InformationCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
    if(!cell) {
        cell = [[[NSBundle mainBundle] loadNibNamed:@"InformationCell" owner:self options:nil] firstObject];
    }
    if (indexPath.row < dataArray.count) {
        cell.nameLabel.text = [dataArray objectAtIndex:indexPath.row];
        cell.valueLabel.text = [valueArray objectAtIndex:indexPath.row];
    }
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    cell.accessoryType = UITableViewCellAccessoryNone;
    return cell;
}
#pragma mark - ASR033WDelegate
- (void)receivedASR033WNetworkState:(ASR033WNetworkState)state error:(NSError *)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (state != ASR033WNetworkStateConnected) {
            [self.navigationController popToRootViewControllerAnimated:YES];
        }
    }];
}
- (void)receivedASR033WDeviceState:(ASR033WResultCode)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (error != ASR033WResultNoError) {
            [Utils showAlert:@"Error" message:@"Failed to get response. Try again."];
        }
    }];
}
#pragma mark - Private
- (void)dismissHUD {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        [SVProgressHUD dismiss];
    }];
}
@end
