//
//  InformationViewController.m
//  ASR033W
//
//  Created by mac on 2020/11/20.
//

#import "InformationViewController.h"
#import "InformationCell.h"
#import <ASR033WSDK/ASR033WSDK.h>
#import <SVProgressHUD/SVProgressHUD.h>

@interface InformationViewController ()<UITableViewDelegate, UITableViewDataSource, ASR033WDelegate>
@property (strong, nonatomic) IBOutlet UITableView *tableView;
@end

@implementation InformationViewController{
    NSArray *dataArray;
    NSMutableArray *valueArray;
    ASR033W *asr033w;
    NSString *_firmwareVersion;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    _firmwareVersion = @"";
    dataArray = [NSArray arrayWithObjects:@"Manufacture number:", @"App version:", @"Application compilation:", @"Baseband version:", @"Baseband compilation:", @"System version:", @"Power-on time:", nil];
    valueArray = [[NSMutableArray alloc] init];
    self.tableView.tableFooterView = [[UIView alloc] initWithFrame:CGRectZero];
    asr033w = [ASR033W sharedInstance];
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:YES];
    asr033w.delegate = self;
    [self performSelector:@selector(dismissHUD) withObject:nil afterDelay:10];
    [SVProgressHUD showWithStatus:@"Information"];
    [asr033w getFirmwareVersion];
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:YES];
    asr033w.delegate = nil;
}
#pragma mark - Table view data source
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return valueArray.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    NSString *cellIdentifier = @"InformationCell";
    InformationCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
    if(!cell) {
        cell = [[[NSBundle mainBundle] loadNibNamed:@"InformationCell" owner:self options:nil] firstObject];
    }
    cell.nameLabel.text = [dataArray objectAtIndex:indexPath.row];
    cell.valueLabel.text = [valueArray objectAtIndex:indexPath.row];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    cell.accessoryType = UITableViewCellAccessoryNone;
    return cell;
}
#pragma mark - ASR033WDelegate
- (void)ASR033W:(ASR033W *)ASR033W receivedFirmwareVersion:(NSString *)firmwareVersion executionStatus:(ASR033WExecutionStatus)statusCode {
    _firmwareVersion = firmwareVersion?:@"";
    [asr033w getReaderInfo];
}
- (void)ASR033W:(ASR033W *)ASR033W receivedReaderInfo:(NSDictionary *)readerInfo {
    [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(dismissHUD) object:nil];
    [SVProgressHUD dismiss];
    if ([readerInfo allValues].count <= 0) {
        return;
    }
    NSString *deviceSerialNumber = [readerInfo valueForKey:@"deviceSerialNumber"]?:@"";
    NSString *appVersion = [readerInfo valueForKey:@"appVersion"]?:@"";
    NSString *applicationCompilation = [readerInfo valueForKey:@"applicationCompilation"]?:@"";
    NSString *basebandCompilation = [readerInfo valueForKey:@"basebandCompilation"]?:@"";
    NSString *systemVersion = [readerInfo valueForKey:@"systemVersion"]?:@"";
    NSString *powerOnTime = [readerInfo valueForKey:@"powerOnTime"]?:@"";
    [valueArray addObject:deviceSerialNumber];
    [valueArray addObject:appVersion];
    [valueArray addObject:applicationCompilation];
    [valueArray addObject:_firmwareVersion];
    [valueArray addObject:basebandCompilation];
    [valueArray addObject:systemVersion];
    [valueArray addObject:powerOnTime];
    [self.tableView reloadData];
}
- (void)ASR033W:(ASR033W *)ASR033W changeNetworkState:(ASR033WNetworkState)state error:(NSError *)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (state != ASR033WNetworkStateConnected) {
            [self.navigationController popToRootViewControllerAnimated:YES];
        }
    }];
}
#pragma mark - Private
- (void)dismissHUD {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        [SVProgressHUD dismiss];
    }];
}
@end
