//
//  AsReaderInfoDefine.h
//  AsReaderDockSDK
//
//  Created by Y.Oshiro on 2021/08/30.
//  Copyright © 2021 Asterisk.Inc. All rights reserved.
//

/**
 *  @brief      This file, AsReaderInfoDefine.h, contains definitions for several important enumerations (enums) and constants related to AsReader devices and their connection modes. It is part of the SDK, and these enums are used to describe the types of readers, their modes, and their connection methods.
 */

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger, ConnectionType){
    ConnectionTypeUSB,
    ConnectionTypeBLE
};

typedef NS_ENUM(NSInteger, ReaderGenerationType){
    GEN0_UNKNOWN = 0,
    GEN1_JACKET = 1,
	GEN2_DONGLE = 2,
	GEN3_ASREADER = 3
};

typedef NS_ENUM(NSInteger, ReaderMode){
    ReaderModeUnknown = -1,
    ReaderModeBarcode = 0,
    ReaderModeRfid = 1,
    ReaderModeNfc = 2,
    ReaderModeDualBarcodeRfid = 3,
    ReaderModeLf = 4,
	ReaderModeDualBarcodeNfc = 5
};

// DO NOT USE THESE. deprecated.
// for backward compatibility section
#define ReaderModeRFID     		(ReaderModeRfid)
#define ReaderModeNFC      	 	(ReaderModeNfc)
#define ReaderModeDual     		(ReaderModeDualBarcodeRfid)
#define ReaderModeRFIDLF   		(ReaderModeLf)
typedef ReaderMode SupportType;
#define SupportTypeBarcode		(ReaderModeBarcode)
#define SupportTypeRFID			(ReaderModeRfid)
#define SupportTypeNFC			(ReaderModeNfc)
#define SupportTypeDual			(ReaderModeDualBarcodeRfid)
#define SupportTypeRFIDLF		(ReaderModeLf)
typedef ReaderMode ReceiveDataType;
#define ReceiveDataTypeBarcode 	(ReaderModeBarcode)
#define ReceiveDataTypeRFID		(ReaderModeRfid)
#define ReceiveDataTypeNFC		(ReaderModeNfc)
#define ReceiveDataTypeRFIDLF	(ReaderModeDualBarcodeRfid)
// ////////////////////////////////////

typedef NS_ENUM(NSUInteger, BarcodeEngineType) {
	BARCODE_ENGINE_NONE = 0x00,
    BARCODE_ENGINE_HONEYWELL = 0x01,
    BARCODE_ENGINE_ZEBRA = 0x02,
    BARCODE_ENGINE_ZEBRA_SSI = 0x03,	
};

