import 'package:flutter/services.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:asreader_m24d_plugin/asreader_m24d_plugin_method_channel.dart';

void main() {
  TestWidgetsFlutterBinding.ensureInitialized();

  MethodChannelAsreaderM24dPlugin platform = MethodChannelAsreaderM24dPlugin();
  const MethodChannel channel = MethodChannel('asreader_m24d_plugin');

  setUp(() {
    TestDefaultBinaryMessengerBinding.instance.defaultBinaryMessenger.setMockMethodCallHandler(
      channel,
      (MethodCall methodCall) async {
        return '42';
      },
    );
  });

  tearDown(() {
    TestDefaultBinaryMessengerBinding.instance.defaultBinaryMessenger.setMockMethodCallHandler(channel, null);
  });

  test('getPlatformVersion', () async {
    expect(await platform.getPlatformVersion(), '42');
  });
}
