package com.example.asreader_m24d_plugin;


import androidx.annotation.NonNull;

import java.util.ArrayList;
import java.util.Map;

import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.MethodChannel.MethodCallHandler;
import io.flutter.plugin.common.MethodChannel.Result;
import jp.co.asterisk.asreader.barcodemanager.SymbologyInfoModel;

/** AsreaderM24dPlugin */
public class AsreaderM24dPlugin implements FlutterPlugin, MethodCallHandler {

  private MethodChannel channel;
  private AsreaderM24dManager asreaderM24dManager;
  public static final String GETPLATFORMVERSION = "getPlatformVersion";
  public static final String GETSDKVERSION = "getSDKVersion";
  public static final String SETCONNECTIONTYPE = "setConnectionType";
  public static final String SETLOGLEVEL = "setLogLevel";
  public static final String GETLOGLEVEL = "getLogLevel";
  public static final String SETLOG = "setLog";
  public static final String REMOVESDKLOG = "removeSDKLog";
  public static final String ENABLEAUTOLAUNCHAPP = "enableAutoLaunchApp";
  public static final String GETCHARACTERSTATUS = "getCharacterStatus";
  public static final String SETDECODEMODE = "setDecodeMode";
  public static final String GETDECODEMODE = "getDecodeMode";
  public static final String SETENCODEMODE = "setEncodeMode";
  public static final String GETENCODEMODE = "getEncodeMode";
  public static final String STARTDECODE = "startDecode";
  public static final String STARTDECODEWITHCOUNTTIME = "startDecodeWithCountTime";
  public static final String STOPDECODE = "stopDecode";
  public static final String FACTORYDEFAULT = "factoryDefault";
  public static final String GETSTOPCONDITION = "getStopCondition";
  public static final String SETBARCODESETTINGS = "setBarcodeSettings";
  public static final String GETBARCODESETTINGS = "getBarcodeSettings";
  public static final String SETSYMBOLOGYALLENABLE = "setSymbologyAllEnable";
  public static final String SETSYMBOLOGYSETTINGS = "setSymbologySettings";
  public static final String SETSYMBOLOGYLISTSETTINGS = "setSymbologyListSettings";
  public static final String SETOCRSETTINGS = "setOCRSettings";
  public static final String SETOCRLISTSETTINGS = "setOCRListSettings";
  public static final String GETSYMBOLOGYSETTINGS = "getSymbologySettings";
  public static final String GETSYMBOLOGYSETTINGSList = "getSymbologySettingsList";
  public static final String GETOCRSETTINGS = "getOCRSettings";
  public static final String GETOCRSETTINGSLIST = "getOCRSettingsList";
  public static final String GETSYSTEMBEEP = "getSystemBeep";
  public static final String SETNOTISEDITING = "setNotisEditing";
  public static final String GETNOTISEDITING = "getNotisEditing";
  public static final String SETPRESENTATIONMODE = "setPresentationMode";
  public static final String GETPRESENTATIONMODE = "getPresentationMode";
  public static final String ISCONNECTED = "isConnected";
  public static final String SETTRIGGERMODE = "setTriggerMode";
  public static final String GETTRIGGERMODE = "getTriggerMode";
  public static final String GETBACKGROUNDREAD = "getBackgroundRead";
  public static final String ISOPEN = "isOpen";
  public static final String OPEN = "open";
  public static final String CLOSE = "close";
  public static final String SETREADERSETTINGS = "setReaderSettings";
  public static final String GETREADERSETTINGS = "getReaderSettings";
  public static final String GETREADERINFO = "getReaderInfo";
  public static final String SETSLEEPTIME = "setSleepTime";
  public static final String GETSLEEPTIME = "getSleepTime";
  public static final String SETSLEEPBEEP = "setSleepBeep";
  public static final String GETSLEEPBEEP = "getSleepBeep";
  public static final String SETSLEEPTIMEANDBEEP = "setSleepTimeAndBeep";
  public static final String GETSLEEPTIMEANDBEEP = "getSleepTimeAndBeep";
  public static final String SETHIDMODE = "setHIDMode";
  public static final String GETHIDMODE = "getHIDMode";

  @Override
  public void onAttachedToEngine(@NonNull FlutterPluginBinding flutterPluginBinding) {
    channel = new MethodChannel(flutterPluginBinding.getBinaryMessenger(), "asreader_m24d_plugin");
    asreaderM24dManager = AsreaderM24dManager.getInstance();
    asreaderM24dManager.currentChannel = channel;
    asreaderM24dManager.currentContext = flutterPluginBinding.getApplicationContext();
    channel.setMethodCallHandler(this);
  }

  @Override
  public void onMethodCall(@NonNull MethodCall call, @NonNull Result result) {
    String method = call.method;
    if (method.equals(GETPLATFORMVERSION)) {
      result.success("Android " + android.os.Build.VERSION.RELEASE);
    } else if (method.equals(GETSDKVERSION)) {
      String sdkVersion = asreaderM24dManager.getSDKVersion();
      result.success(sdkVersion);
    } else if (method.equals(SETCONNECTIONTYPE)) {
      int connectionType = call.argument("connectionType");
      asreaderM24dManager.setConnectionType(connectionType);
    } else if (method.equals(SETLOGLEVEL)) {
      int logLevel = call.argument("logLevel");
      asreaderM24dManager.setLogLevel(logLevel);
    } else if (method.equals(GETLOGLEVEL)) {
      int logLevel = asreaderM24dManager.getLogLevel();
      result.success(logLevel);
    } else if (method.equals(SETLOG)) {
      boolean enable = call.argument("enable");
      asreaderM24dManager.setLog(enable);
    } else if (method.equals(REMOVESDKLOG)) {
      asreaderM24dManager.removeSDKLog();
    } else if (method.equals(ENABLEAUTOLAUNCHAPP)) {
      boolean enable = call.argument("enable");
      String aliasName = call.argument("aliasName");
      asreaderM24dManager.enableAutoLaunchApp(enable, aliasName);
    } else if (method.equals(GETCHARACTERSTATUS)) {
      int status = asreaderM24dManager.getCharacterStatus();
      result.success(status);
    } else if (method.equals(SETDECODEMODE)) {
      int mode = call.argument("mode");
      asreaderM24dManager.setDecodeMode(mode);
    } else if (method.equals(GETDECODEMODE)) {
      int status = asreaderM24dManager.getDecodeMode();
      result.success(status);
    } else if (method.equals(SETENCODEMODE)) {
      int qrEncodeMode = call.argument("qrEncodeMode");
      asreaderM24dManager.setEncodeMode(qrEncodeMode);
    } else if (method.equals(GETENCODEMODE)) {
      int mode = asreaderM24dManager.getEncodeMode();
      result.success(mode);
    } else if (method.equals(STARTDECODE)) {
      asreaderM24dManager.startDecode();
    } else if (method.equals(STARTDECODEWITHCOUNTTIME)) {
      int count = call.argument("count");
      int time = call.argument("time");
      asreaderM24dManager.startDecodeWithCountTime(count, time);
    } else if (method.equals(STOPDECODE)) {
      asreaderM24dManager.stopDecode();
    } else if (method.equals(FACTORYDEFAULT)) {
      asreaderM24dManager.factoryDefault();
    } else if (method.equals(GETSTOPCONDITION)) {
      asreaderM24dManager.getStopCondition();
    } else if (method.equals(SETBARCODESETTINGS)) {
      int memoryType = call.argument("memoryType");
      int settingsType = call.argument("settingsType");
      asreaderM24dManager.setBarcodeSettings(memoryType, settingsType);
    } else if (method.equals(GETBARCODESETTINGS)) {
      int settingsType = call.argument("settingsType");
      asreaderM24dManager.getBarcodeSettings(settingsType);
    } else if (method.equals(SETSYMBOLOGYALLENABLE)) {
      int memoryType = call.argument("memoryType");
      boolean isEnable = call.argument("isEnable");
      asreaderM24dManager.setSymbologyAllEnable(memoryType, isEnable);
    } else if (method.equals(SETSYMBOLOGYSETTINGS)) {
      int memoryType = call.argument("memoryType");
      int symbology = call.argument("symbology");
      boolean isEnable = call.argument("isEnable");
      asreaderM24dManager.setSymbologySettings(memoryType, symbology, isEnable);
    } else if (method.equals(SETSYMBOLOGYLISTSETTINGS)) {
      int memoryType = call.argument("memoryType");
      ArrayList<Map<String, Object>> symbologyInfoList = call.argument("symbologyInfoList");
      asreaderM24dManager.setSymbologyListSettings(memoryType, symbologyInfoList);
    } else if (method.equals(SETOCRSETTINGS)) {
      int memoryType = call.argument("memoryType");
      int ocr = call.argument("ocr");
      boolean isEnable = call.argument("isEnable");
      asreaderM24dManager.setOCRSettings(memoryType, ocr, isEnable);
    } else if (method.equals(SETOCRLISTSETTINGS)) {
      int memoryType = call.argument("memoryType");
      ArrayList<Map<String, Object>> ocrInfoList = call.argument("ocrInfoList");
      asreaderM24dManager.setOCRListSettings(memoryType, ocrInfoList);
    } else if (method.equals(GETSYMBOLOGYSETTINGS)) {
      int symbology = call.argument("symbology");
      asreaderM24dManager.getSymbologySettings(symbology);
    } else if (method.equals(GETSYMBOLOGYSETTINGSList)) {
      ArrayList<Integer> symbologyList = call.argument("symbologyList");
      asreaderM24dManager.getSymbologySettingsList(symbologyList);
    } else if (method.equals(GETOCRSETTINGS)) {
      int ocr = call.argument("ocr");
      asreaderM24dManager.getOCRSettings(ocr);
    } else if (method.equals(GETOCRSETTINGSLIST)) {
      ArrayList<Integer> ocrList = call.argument("ocrList");
      asreaderM24dManager.getOCRSettingsList(ocrList);
    } else if (method.equals(GETSYSTEMBEEP)) {
      int beep = asreaderM24dManager.getSystemBeep();
      result.success(beep);
    } else if (method.equals(SETNOTISEDITING)) {
      int memoryType = call.argument("memoryType");
      boolean isEnabled = call.argument("isEnabled");
      asreaderM24dManager.setNotisEditing(memoryType, isEnabled);
    } else if (method.equals(GETNOTISEDITING)) {
      asreaderM24dManager.getNotisEditing();
    } else if (method.equals(SETPRESENTATIONMODE)) {
      int memoryType = call.argument("memoryType");
      int settingsType = call.argument("settingsType");
      asreaderM24dManager.setPresentationMode(memoryType, settingsType);
    } else if (method.equals(GETPRESENTATIONMODE)) {
      asreaderM24dManager.getPresentationMode();
    } else if (method.equals(ISCONNECTED)) {
      boolean status = asreaderM24dManager.isConnected();
      result.success(status);
    } else if (method.equals(SETTRIGGERMODE)) {
      int mode = call.argument("mode");
      asreaderM24dManager.setTriggerMode(mode);
    } else if (method.equals(GETTRIGGERMODE)) {
      int mode = asreaderM24dManager.getTriggerMode();
      result.success(mode);
    } else if (method.equals(GETBACKGROUNDREAD)) {
      boolean status = asreaderM24dManager.getBackgroundRead();
      result.success(status);
    } else if (method.equals(ISOPEN)) {
      boolean status = asreaderM24dManager.isOpen();
      result.success(status);
    } else if (method.equals(OPEN)) {
      asreaderM24dManager.open();
    } else if (method.equals(CLOSE)) {
      asreaderM24dManager.close();
    } else if (method.equals(SETREADERSETTINGS)) {
      boolean beep = call.argument("beep");
      boolean vib = call.argument("vib");
      boolean aimer = call.argument("aimer");
      boolean led = call.argument("led");
      boolean powerOnBeep = call.argument("powerOnBeep");
      asreaderM24dManager.setReaderSettings(beep, vib, aimer, led, powerOnBeep);
    } else if (method.equals(GETREADERSETTINGS)) {
      asreaderM24dManager.getReaderSettings();
    } else if (method.equals(GETREADERINFO)) {
      asreaderM24dManager.getReaderInfo();
    } else if (method.equals(SETSLEEPTIME)) {
      int sleepTime = call.argument("sleepTime");
      asreaderM24dManager.setSleepTime(sleepTime);
    } else if (method.equals(GETSLEEPTIME)) {
      asreaderM24dManager.getSleepTime();
    } else if (method.equals(SETSLEEPBEEP)) {
      boolean isSleepBeepOn = call.argument("isSleepBeepOn");
      asreaderM24dManager.setSleepBeep(isSleepBeepOn);
    } else if (method.equals(GETSLEEPBEEP)) {
      asreaderM24dManager.getSleepBeep();
    } else if (method.equals(SETSLEEPTIMEANDBEEP)) {
      int sleepTime = call.argument("sleepTime");
      boolean isSleepBeepOn = call.argument("isSleepBeepOn");
      asreaderM24dManager.setSleepTimeAndBeep(sleepTime, isSleepBeepOn);
    } else if (method.equals(GETSLEEPTIMEANDBEEP)) {
      asreaderM24dManager.getSleepTimeAndBeep();
    } else if (method.equals(SETHIDMODE)) {
      int hidMode = call.argument("hidMode");
      asreaderM24dManager.setHIDMode(hidMode);
    } else if (method.equals(GETHIDMODE)) {
      asreaderM24dManager.getHIDMode();
    } else {
      result.notImplemented();
    }
  }

  @Override
  public void onDetachedFromEngine(@NonNull FlutterPluginBinding binding) {
    channel.setMethodCallHandler(null);
  }
}
