package com.example.asreader_m24d_plugin;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import io.flutter.plugin.common.MethodChannel;
import jp.co.asterisk.asreader.a24d.communicationmanager.connection.ConnectionType;
import jp.co.asterisk.asreader.a24d.sdk.AsReader;
import jp.co.asterisk.asreader.a24d.utility.AsReaderError;
import jp.co.asterisk.asreader.a24d.utility.LogLevel;
import jp.co.asterisk.asreader.barcodemanager.BarcodeManagerCallback;
import jp.co.asterisk.asreader.barcodemanager.SymbologyInfoModel;
import jp.co.asterisk.asreader.barcodemanager.define.BarcodeConst;
import jp.co.asterisk.asreader.barcodemanager.define.BarcodeManagerError;
import jp.co.asterisk.asreader.barcodemanager.define.BarcodeResult;
import jp.co.asterisk.asreader.barcodemanager.define.OCR;
import jp.co.asterisk.asreader.barcodemanager.define.Symbology;
import jp.co.asterisk.asreader.barcodemanager.model.OCRInfoModel;
import jp.co.asterisk.asreader.devicemanager.DeviceConst;
import jp.co.asterisk.asreader.devicemanager.DeviceManagerCallback;

public class AsreaderM24dManager implements DeviceManagerCallback, BarcodeManagerCallback {
    public static final String ONCONNECT = "onConnect";
    public static final String ONBATTERYSTATERECEIVED = "onBatteryStateReceived";
    public static final String ONTRIGGEREVENTRECEIVED = "onTriggerEventReceived";
    public static final String ONREADERINFORECEIVED = "onReaderInfoReceived";
    public static final String ONSETREADERSETTINGSUCCESS = "onSetReaderSettingSuccess";
    public static final String ONREADERSETTINGRECEIVED = "onReaderSettingReceived";
    public static final String ONSLEEPSETTINGRECEIVED = "onSleepSettingReceived";
    public static final String ONSETCHARGECONTROLSUCCESS = "onSetChargeControlSuccess";
    public static final String ONHIDMODERECEIVED = "onHIDModeReceived";
    public static final String ONDEVICEMANAGERERROR = "onDeviceManagerError";
    public static final String ONRECEIVEDBARCODEDECODEDATA = "onReceivedBarcodeDecodeData";
    public static final String ONRECEIVEDBARCODEDECODEDATABYTE = "onReceivedBarcodeDecodeDataByte";
    public static final String ONRECEIVEDRESPONSE = "onReceivedResponse";
    public static final String ONBARCODEMANAGERSTANDBYREADY = "onBarcodeManagerStandByReady";
    public static final String ONBARCODEMANAGERERROR = "onBarcodeManagerError";

    public MethodChannel currentChannel;
    public Context currentContext;
    private static AsreaderM24dManager mInstance = null;
    private String logTag = "AsreaderM24dManager";
    private Handler mainHandler = new Handler(Looper.getMainLooper());

    public static AsreaderM24dManager getInstance() {
        if (mInstance == null) mInstance = new AsreaderM24dManager();
        return mInstance;
    }
    //AsReader
    public String getSDKVersion() {
        Log.d(logTag, "getSDKVersion");
        return AsReader.getInstance().getVersion();
    }
    public void setConnectionType(int connectionType) {
        Log.d(logTag, "setConnectionType:" + connectionType);
        ConnectionType type;
        if (connectionType == 0) {
            type = ConnectionType.BLE;
        } else {
            type = ConnectionType.USB;
        }
        AsReader.getInstance().initialize(currentContext, type);
        AsReader.getInstance().getDeviceManager().setCallback(this);
        AsReader.getInstance().getBarcodeManager().setCallback(this);
        AsReader.getInstance().getDeviceManager().setPackageName(currentContext.getPackageName());
        AsReader.getInstance().getDeviceManager().open();
    }
    public void setLogLevel(int logLevel) {
        Log.d(logTag, "setLogLevel:" + logLevel);
        LogLevel level = LogLevel.Fatal;
        if (logLevel == 1) {
            level = LogLevel.Fatal;
        } else if (logLevel == 2) {
            level = LogLevel.Error;
        } else if (logLevel == 3) {
            level = LogLevel.Warning;
        } else if (logLevel == 4) {
            level = LogLevel.Information;
        } else if (logLevel == 5) {
            level = LogLevel.Debug;
        }
        AsReader.getInstance().setLogLevel(level);
    }
    public int getLogLevel() {
        Log.d(logTag, "getLogLevel");
        LogLevel level = AsReader.getInstance().getLogLevel();
        int logLevel = 1;
        if (level == LogLevel.Fatal) {
            logLevel = 1;
        } else if (level == LogLevel.Error) {
            logLevel = 2;
        } else if (level == LogLevel.Warning) {
            logLevel = 3;
        } else if (level == LogLevel.Information) {
            logLevel = 4;
        } else if (level == LogLevel.Debug) {
            logLevel = 5;
        }
        return logLevel;
    }
    public void setLog(boolean enable) {
        Log.d(logTag, "setLog:" + enable);
        AsReader.getInstance().setLog(enable);
    }
    public void removeSDKLog() {
        Log.d(logTag, "removeSDKLog");
        AsReader.getInstance().removeSDKLog();
    }
    public void enableAutoLaunchApp(boolean enable, String aliasName) {
        Log.d(logTag, "enableAutoLaunchApp:" + enable + " aliasName:" + aliasName);
        AsReader.getInstance().enableAutoLaunchApp(enable, aliasName);
    }
    //BarcodeManager
    public int getCharacterStatus() {
        Log.d(logTag, "getCharacterStatus");
        BarcodeConst.BarcodeSettings barcodeSettings = AsReader.getInstance().getBarcodeManager().getCharacterStatus();
        int mode = getBarcodeSettingsMode(barcodeSettings);
        return mode;
    }
    public void setDecodeMode(int mode) {
        Log.d(logTag, "setDecodeMode:" + mode);
        BarcodeConst.BarcodeSettings barcodeSettings = getModeBarcodeSettings(mode);
        AsReader.getInstance().getBarcodeManager().setDecodeMode(barcodeSettings);
    }
    public int getDecodeMode() {
        Log.d(logTag, "getDecodeMode");
        BarcodeConst.BarcodeSettings barcodeSettings = AsReader.getInstance().getBarcodeManager().getDecodeMode();
        int mode = getBarcodeSettingsMode(barcodeSettings);
        return mode;
    }
    public void setEncodeMode(int qrEncodeMode) {
        Log.d(logTag, "setEncodeMode:" + qrEncodeMode);
        BarcodeConst.QREncodeMode mode = BarcodeConst.QREncodeMode.AUTO;
        if (qrEncodeMode == 0) {
            mode = BarcodeConst.QREncodeMode.AUTO;
        } else if (qrEncodeMode == 1) {
            mode = BarcodeConst.QREncodeMode.SHIFT_JIS;
        } else if (qrEncodeMode == 2) {
            mode = BarcodeConst.QREncodeMode.EUC_KR;
        } else if (qrEncodeMode == 3) {
            mode = BarcodeConst.QREncodeMode.UTF_8;
        } else if (qrEncodeMode == 4) {
            mode = BarcodeConst.QREncodeMode.UTF_16;
        } else if (qrEncodeMode == 5) {
            mode = BarcodeConst.QREncodeMode.UTF_32;
        }
        AsReader.getInstance().getBarcodeManager().setEncodeMode(mode);
    }
    public int getEncodeMode() {
        Log.d(logTag, "getEncodeMode");
        BarcodeConst.QREncodeMode qrEncodeMode = AsReader.getInstance().getBarcodeManager().getEncodeMode();
        int mode = 0;
        if (qrEncodeMode == BarcodeConst.QREncodeMode.AUTO) {
            mode = 0;
        } else if (qrEncodeMode == BarcodeConst.QREncodeMode.SHIFT_JIS) {
            mode = 1;
        } else if (qrEncodeMode == BarcodeConst.QREncodeMode.EUC_KR) {
            mode = 2;
        } else if (qrEncodeMode == BarcodeConst.QREncodeMode.UTF_8) {
            mode = 3;
        } else if (qrEncodeMode == BarcodeConst.QREncodeMode.UTF_16) {
            mode = 4;
        } else if (qrEncodeMode == BarcodeConst.QREncodeMode.UTF_32) {
            mode = 5;
        }
        return mode;
    }
    public void startDecode() {
        Log.d(logTag, "startDecode");
        AsReader.getInstance().getBarcodeManager().startDecode();
    }
    public void startDecodeWithCountTime(int count, int time) {
        Log.d(logTag, "startDecode:" + count + " time" + time);
        AsReader.getInstance().getBarcodeManager().startDecode(count, time);
    }
    public void stopDecode() {
        Log.d(logTag, "stopDecode");
        AsReader.getInstance().getBarcodeManager().stopDecode();
    }
    public void factoryDefault() {
        Log.d(logTag, "factoryDefault");
        AsReader.getInstance().getBarcodeManager().factoryDefault();
    }
    public void getStopCondition() {
        Log.d(logTag, "getStopCondition");
        AsReader.getInstance().getBarcodeManager().getStopCondition();
    }
    public void setBarcodeSettings(int memoryType, int settingsType) {
        Log.d(logTag, "setBarcodeSettings:" + memoryType + " settingsType" + settingsType);
        BarcodeConst.MemoryType type = getModeMemoryType(memoryType);
        BarcodeConst.BarcodeSettings barcodeSettings = getModeBarcodeSettings(settingsType);
        AsReader.getInstance().getBarcodeManager().setBarcodeSettings(type, barcodeSettings);
    }
    public void getBarcodeSettings(int settingsType) {
        Log.d(logTag, "getBarcodeSettings:" + settingsType);
        BarcodeConst.BarcodeSettings barcodeSettings = getModeBarcodeSettings(settingsType);
        AsReader.getInstance().getBarcodeManager().getBarcodeSettings(barcodeSettings);
    }
    public void setSymbologyAllEnable(int memoryType, boolean isEnable) {
        Log.d(logTag, "setSymbologyAllEnable:" + memoryType + " isEnable" + isEnable);
        BarcodeConst.MemoryType type = getModeMemoryType(memoryType);
        AsReader.getInstance().getBarcodeManager().setSymbologyAllEnable(type, isEnable);
    }
    public void setSymbologySettings(int memoryType, int symbology, boolean isEnable) {
        Log.d(logTag, "setSymbologySettings:" + memoryType + " symbology" + symbology + " isEnable" + isEnable);
        BarcodeConst.MemoryType type = getModeMemoryType(memoryType);
        Symbology s = getModeSymbology(symbology);
        AsReader.getInstance().getBarcodeManager().setSymbologySettings(type, s, isEnable);
    }
    public void setSymbologyListSettings(int memoryType, ArrayList<Map<String, Object>> symbologyInfoList) {
        Log.d(logTag, "setSymbologyListSettings:" + memoryType + " symbologyInfoList" + symbologyInfoList);
        BarcodeConst.MemoryType type = getModeMemoryType(memoryType);
        ArrayList<SymbologyInfoModel> array = new ArrayList<>();
        for (Map map : symbologyInfoList) {
            int index = (int) map.get("symbology");
            Symbology symbology = getModeSymbology(index);
            boolean isEnableStatus = (boolean) map.get("isEnableStatus");
            SymbologyInfoModel model = new SymbologyInfoModel(symbology, isEnableStatus);
            array.add(model);
        }
        AsReader.getInstance().getBarcodeManager().setSymbologySettings(type, array);
    }
    public void setOCRSettings(int memoryType, int ocr, boolean isEnable) {
        Log.d(logTag, "setOCRSettings:" + memoryType + " ocr" + ocr + " isEnable" + isEnable);
        BarcodeConst.MemoryType type = getModeMemoryType(memoryType);
        OCR o = getModeOCR(ocr);
        AsReader.getInstance().getBarcodeManager().setOCRSettings(type, o, isEnable);
    }
    public void setOCRListSettings(int memoryType, ArrayList<Map<String, Object>> ocrInfoList) {
        Log.d(logTag, "setOCRListSettings:" + memoryType + " ocrInfoList" + ocrInfoList);
        BarcodeConst.MemoryType type = getModeMemoryType(memoryType);
        ArrayList<OCRInfoModel> array = new ArrayList<>();
        for (Map map : ocrInfoList) {
            int index = (int) map.get("ocr");
            OCR ocr = getModeOCR(index);
            boolean isEnableStatus = (boolean) map.get("isEnable");
            OCRInfoModel model = new OCRInfoModel(ocr, isEnableStatus);
            array.add(model);
        }
        AsReader.getInstance().getBarcodeManager().setOCRSettings(type, array);
    }
    public void getSymbologySettings(int symbology) {
        Log.d(logTag, "getSymbologySettings:" + symbology);
        Symbology s = getModeSymbology(symbology);
        AsReader.getInstance().getBarcodeManager().getSymbologySettings(s);
    }
    public void getSymbologySettingsList(ArrayList<Integer> symbologyList) {
        Log.d(logTag, "getSymbologySettingsList:" + symbologyList);
        ArrayList<Symbology> array = new ArrayList<>();
        for (int i : symbologyList) {
            Symbology s = getModeSymbology(i);
            array.add(s);
        }
        AsReader.getInstance().getBarcodeManager().getSymbologySettings(array);
    }
    public void getOCRSettings(int ocr) {
        Log.d(logTag, "getOCRSettings:" + ocr);
        OCR o = getModeOCR(ocr);
        AsReader.getInstance().getBarcodeManager().getOCRSettings(o);
    }
    public void getOCRSettingsList(ArrayList<Integer> ocrList) {
        Log.d(logTag, "getOCRSettingsList:" + ocrList);
        ArrayList<OCR> array = new ArrayList<>();
        for (int i : ocrList) {
            OCR s = getModeOCR(i);
            array.add(s);
        }
        AsReader.getInstance().getBarcodeManager().getOCRSettings(array);
    }
    public int getSystemBeep() {
        Log.d(logTag, "getSystemBeep");
        BarcodeConst.SystemBeepSoundType type = AsReader.getInstance().getBarcodeManager().getSystemBeep();
        int beep = getSystemBeepMode(type);
        return beep;
    }
    public void setNotisEditing(int memoryType, boolean isEnabled) {
        Log.d(logTag, "setNotisEditing:" + memoryType + " isEnabled:" + isEnabled);
        BarcodeConst.MemoryType type = getModeMemoryType(memoryType);
        AsReader.getInstance().getBarcodeManager().setNotisEditing(type, isEnabled);
    }
    public void getNotisEditing() {
        Log.d(logTag, "getNotisEditing");
        AsReader.getInstance().getBarcodeManager().getNotisEditing();
    }
    public void setPresentationMode(int memoryType, int settingsType) {
        Log.d(logTag, "setPresentationMode:" + memoryType + " settingsType:" + settingsType);
        BarcodeConst.MemoryType type = getModeMemoryType(memoryType);
        BarcodeConst.BarcodeSettings barcodeSettings = getModeBarcodeSettings(settingsType);
        AsReader.getInstance().getBarcodeManager().setPresentationMode(type, barcodeSettings);
    }
    public void getPresentationMode() {
        Log.d(logTag, "getPresentationMode");
        AsReader.getInstance().getBarcodeManager().getPresentationMode();
    }
    public boolean isConnected() {
        Log.d(logTag, "isConnected");
        boolean status = AsReader.getInstance().getDeviceManager().isConnected();
        return status;
    }
    public void setTriggerMode(int mode) {
        Log.d(logTag, "setTriggerMode:" + mode);
        DeviceConst.TriggerMode triggerMode = DeviceConst.TriggerMode.MANUAL;
        if (mode == 0) {
            triggerMode = DeviceConst.TriggerMode.MANUAL;
        } else if (mode == 1) {
            triggerMode = DeviceConst.TriggerMode.AUTO;
        }
        AsReader.getInstance().getDeviceManager().setTriggerMode(triggerMode);
    }
    public int getTriggerMode() {
        Log.d(logTag, "getTriggerMode");
        int triggerMode = 0;
        DeviceConst.TriggerMode mode = AsReader.getInstance().getDeviceManager().getTriggerMode();
        if (mode == DeviceConst.TriggerMode.MANUAL) {
            triggerMode = 0;
        } else if (mode == DeviceConst.TriggerMode.AUTO) {
            triggerMode = 1;
        }
        return triggerMode;
    }
    public boolean getBackgroundRead() {
        Log.d(logTag, "getBackgroundRead");
        boolean status = AsReader.getInstance().getDeviceManager().getBackgroundRead();
        return status;
    }
    public boolean isOpen() {
        Log.d(logTag, "isOpen");
        boolean status = AsReader.getInstance().getDeviceManager().isOpen();
        return status;
    }
    public void open() {
        Log.d(logTag, "open");
        AsReader.getInstance().getDeviceManager().open();
    }
    public void close() {
        Log.d(logTag, "close");
        AsReader.getInstance().getDeviceManager().close();
    }
    public void setReaderSettings(boolean beep, boolean vib, boolean aimer, boolean led, boolean powerOnBeep) {
        Log.d(logTag, "setReaderSettings:" + beep + " vib:" + vib + " aimer:" + aimer + " led:" + led + " powerOnBeep:" + powerOnBeep);
        AsReader.getInstance().getDeviceManager().setReaderSettings(beep, vib, aimer, led, powerOnBeep);
    }
    public void getReaderSettings() {
        Log.d(logTag, "getReaderSettings");
        AsReader.getInstance().getDeviceManager().getReaderSettings();
    }
    public void getReaderInfo() {
        Log.d(logTag, "getReaderInfo");
        AsReader.getInstance().getDeviceManager().getReaderInfo();
    }
    public void setSleepTime(int sleepTime) {
        Log.d(logTag, "setSleepTime:" + sleepTime);
        AsReader.getInstance().getDeviceManager().setSleepTime(sleepTime);
    }
    public void getSleepTime() {
        Log.d(logTag, "getSleepTime");
        AsReader.getInstance().getDeviceManager().getSleepTime();
    }
    public void setSleepBeep(boolean isSleepBeepOn) {
        Log.d(logTag, "setSleepBeep:" + isSleepBeepOn);
        AsReader.getInstance().getDeviceManager().setSleepBeep(isSleepBeepOn);
    }
    public void getSleepBeep() {
        Log.d(logTag, "getSleepBeep");
        AsReader.getInstance().getDeviceManager().getSleepBeep();
    }
    public void setSleepTimeAndBeep(int sleepTime, boolean isSleepBeepOn) {
        Log.d(logTag, "setSleepTimeAndBeep:" + sleepTime + " isSleepBeepOn:" + isSleepBeepOn);
        AsReader.getInstance().getDeviceManager().setSleepTimeAndBeep(sleepTime, isSleepBeepOn);
    }
    public void getSleepTimeAndBeep() {
        Log.d(logTag, "getSleepTimeAndBeep");
        AsReader.getInstance().getDeviceManager().getSleepTimeAndBeep();
    }
    public void setHIDMode(int hid) {
        Log.d(logTag, "setHIDMode:" + hid);
        DeviceConst.HIDType type = DeviceConst.HIDType.ANDROID_HID;
        if (hid == 0) {
            type = DeviceConst.HIDType.ANDROID_HID;
        } else if (hid == 1) {
            type = DeviceConst.HIDType.IOS_HID;
        } else if (hid == 2) {
            type = DeviceConst.HIDType.HID_OFF;
        } else if (hid == 3) {
            type = DeviceConst.HIDType.NOT_APPLICABLE;
        }
        AsReader.getInstance().getDeviceManager().setHIDMode(type);
    }
    public void getHIDMode() {
        Log.d(logTag, "getHIDMode");
        AsReader.getInstance().getDeviceManager().getHIDMode();
    }
    //DeviceManagerCallback
    @Override
    public void onConnect(boolean b) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", b);
                map.put("method", ONCONNECT);
                currentChannel.invokeMethod(ONCONNECT, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onConnect result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onConnect errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onConnect notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onBatteryStateReceived(int i) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", i);
                map.put("method", ONBATTERYSTATERECEIVED);
                currentChannel.invokeMethod(ONBATTERYSTATERECEIVED, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onBatteryStateReceived result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onBatteryStateReceived errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onBatteryStateReceived notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onTriggerEventReceived(DeviceConst.DeviceTriggerEvent deviceTriggerEvent) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                int event = 0;
                if (deviceTriggerEvent == DeviceConst.DeviceTriggerEvent.PUSH_NONE) {
                    event = 0;
                } else if (deviceTriggerEvent == DeviceConst.DeviceTriggerEvent.PUSH_RIGHT) {
                    event = 1;
                } else if (deviceTriggerEvent == DeviceConst.DeviceTriggerEvent.PUSH_LEFT) {
                    event = 2;
                }
                Map<String, Object> map = new HashMap<>();
                map.put("result", event);
                map.put("method", ONTRIGGEREVENTRECEIVED);
                currentChannel.invokeMethod(ONTRIGGEREVENTRECEIVED, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onTriggerEventReceived result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onTriggerEventReceived errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onTriggerEventReceived notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onReaderInfoReceived(Map<String, String> info) {
        DeviceManagerCallback.super.onReaderInfoReceived(info);
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, String> map = new HashMap<>();
                Set<String> keys = info.keySet();
                for (String key : keys) {
                    map.put(key, info.get(key));
                }
                map.put("method", ONREADERINFORECEIVED);
                currentChannel.invokeMethod(ONREADERINFORECEIVED, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onReaderInfoReceived result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onReaderInfoReceived errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onReaderInfoReceived notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onSetReaderSettingSuccess() {
        DeviceManagerCallback.super.onSetReaderSettingSuccess();
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, String> map = new HashMap<>();
                map.put("method", ONSETREADERSETTINGSUCCESS);
                currentChannel.invokeMethod(ONSETREADERSETTINGSUCCESS, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onSetReaderSettingSuccess result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onSetReaderSettingSuccess errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onSetReaderSettingSuccess notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onReaderSettingReceived(Map<String, Boolean> settingParamMap) {
        DeviceManagerCallback.super.onReaderSettingReceived(settingParamMap);
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                Set<String> keys = settingParamMap.keySet();
                for (String key : keys) {
                    map.put(key, settingParamMap.get(key));
                }
                map.put("method", ONREADERSETTINGRECEIVED);
                currentChannel.invokeMethod(ONREADERSETTINGRECEIVED, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onReaderSettingReceived result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onReaderSettingReceived errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onReaderSettingReceived notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onSleepSettingReceived(Map<String, String> sleepParamMAp) {
        DeviceManagerCallback.super.onSleepSettingReceived(sleepParamMAp);
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, String> map = new HashMap<>();
                Set<String> keys = sleepParamMAp.keySet();
                for (String key : keys) {
                    map.put(key, sleepParamMAp.get(key));
                }
                map.put("method", ONSLEEPSETTINGRECEIVED);
                currentChannel.invokeMethod(ONSLEEPSETTINGRECEIVED, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onSleepSettingReceived result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onSleepSettingReceived errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onSleepSettingReceived notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onSetChargeControlSuccess() {
        DeviceManagerCallback.super.onSetChargeControlSuccess();
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, String> map = new HashMap<>();
                map.put("method", ONSETCHARGECONTROLSUCCESS);
                currentChannel.invokeMethod(ONSETCHARGECONTROLSUCCESS, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onSetChargeControlSuccess result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onSetChargeControlSuccess errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onSetChargeControlSuccess notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onHIDModeReceived(DeviceConst.HIDType hidType) {
        DeviceManagerCallback.super.onHIDModeReceived(hidType);
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                int event = 0;
                if (hidType == DeviceConst.HIDType.ANDROID_HID) {
                    event = 0;
                } else if (hidType == DeviceConst.HIDType.IOS_HID) {
                    event = 1;
                } else if (hidType == DeviceConst.HIDType.HID_OFF) {
                    event = 2;
                } else if (hidType == DeviceConst.HIDType.NOT_APPLICABLE) {
                    event = 3;
                }
                Map<String, Object> map = new HashMap<>();
                map.put("result", event);
                map.put("method", ONHIDMODERECEIVED);
                currentChannel.invokeMethod(ONHIDMODERECEIVED, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onHIDModeReceived result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onHIDModeReceived errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onHIDModeReceived notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onDeviceManagerError(AsReaderError.ErrorCode errorCode) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                int event = getDeviceManagerError(errorCode);
                Map<String, Object> map = new HashMap<>();
                map.put("result", event);
                map.put("method", ONDEVICEMANAGERERROR);
                currentChannel.invokeMethod(ONDEVICEMANAGERERROR, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onDeviceManagerError result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onDeviceManagerError errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onDeviceManagerError notImplemented");
                    }
                });
            }
        });
    }

    //BarcodeManagerCallback
    @Override
    public void onReceivedBarcodeDecodeData(String decodeData, Map<String, String> parameter) {
        BarcodeManagerCallback.super.onReceivedBarcodeDecodeData(decodeData, parameter);
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<Object, Object> map = new HashMap<>();
                Set<String> keys = parameter.keySet();
                for (String key : keys) {
                    map.put(key, parameter.get(key));
                }
                map.put("decodeData", decodeData);
                map.put("method", ONRECEIVEDBARCODEDECODEDATA);
                currentChannel.invokeMethod(ONRECEIVEDBARCODEDECODEDATA, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onReceivedBarcodeDecodeData result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onReceivedBarcodeDecodeData errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onReceivedBarcodeDecodeData notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onReceivedBarcodeDecodeData(byte[] decodeData) {
        BarcodeManagerCallback.super.onReceivedBarcodeDecodeData(decodeData);
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", decodeData);
                map.put("method", ONRECEIVEDBARCODEDECODEDATABYTE);
                currentChannel.invokeMethod(ONRECEIVEDBARCODEDECODEDATABYTE, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onReceivedBarcodeDecodeDataByte result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onReceivedBarcodeDecodeDataByte errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onReceivedBarcodeDecodeDataByte notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onReceivedResponse(BarcodeConst.BarcodeCommandAction type, BarcodeResult result) {
        BarcodeManagerCallback.super.onReceivedResponse(type, result);
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> barcodeResultMap = new HashMap<>();
                int status;
                if (result.getStatus() == BarcodeResult.Status.SUCCESS) {
                    status = 0;
                } else {
                    status = 1;
                }
                barcodeResultMap.put("getStatus", status);
                barcodeResultMap.put("getResult", getResult(result.getResult()));
                barcodeResultMap.put("getMessage", result.getMessage());
                ArrayList<SymbologyInfoModel> array = result.getSymbologyInfoArray();
                ArrayList<Map<String, Object>> array2 = new ArrayList<>();
                if (array != null && array.size() > 0) {
                    for (SymbologyInfoModel model : array) {
                        Map<String, Object> symbologyInfoModelMap = new HashMap<>();
                        symbologyInfoModelMap.put("symbology", getSymbologyMode(model.symbology));
                        symbologyInfoModelMap.put("isEnableStatus", model.isEnableStatus);
                        array2.add(symbologyInfoModelMap);
                    }
                }
                barcodeResultMap.put("getSymbologyInfoArray", array2);
                Map<String, Object> map = new HashMap<>();
                int event = getBarcodeCommandAction(type);
                map.put("type", event);
                map.put("result", barcodeResultMap);
                map.put("method", ONRECEIVEDRESPONSE);
                currentChannel.invokeMethod(ONRECEIVEDRESPONSE, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onReceivedResponse result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onReceivedResponse errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onReceivedResponse notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onBarcodeManagerStandByReady() {
        BarcodeManagerCallback.super.onBarcodeManagerStandByReady();
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, String> map = new HashMap<>();
                map.put("method", ONBARCODEMANAGERSTANDBYREADY);
                currentChannel.invokeMethod(ONBARCODEMANAGERSTANDBYREADY, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onBarcodeManagerStandByReady result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onBarcodeManagerStandByReady errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onBarcodeManagerStandByReady notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onBarcodeManagerError(BarcodeManagerError barcodeManagerError) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                String error =  barcodeManagerError.getMessage();
                Map<String, String> map = new HashMap<>();
                map.put("result", error);
                map.put("method", ONBARCODEMANAGERERROR);
                currentChannel.invokeMethod(ONBARCODEMANAGERERROR, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onBarcodeManagerError result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onBarcodeManagerError errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onBarcodeManagerError notImplemented");
                    }
                });
            }
        });
    }

    private int getBarcodeSettingsMode(BarcodeConst.BarcodeSettings barcodeSettings) {
        int mode = 0;
        if (barcodeSettings == BarcodeConst.BarcodeSettings.DECODE_MODE_SINGLE) {
            mode = 0;
        } else if (barcodeSettings == BarcodeConst.BarcodeSettings.DECODE_MODE_CONTINUOUS) {
            mode = 1;
        } else if (barcodeSettings == BarcodeConst.BarcodeSettings.NOTIS_EDITING) {
            mode = 2;
        } else if (barcodeSettings == BarcodeConst.BarcodeSettings.CHARACTER_CODE_ID_SYMBOL) {
            mode = 3;
        } else if (barcodeSettings == BarcodeConst.BarcodeSettings.CHARACTER_CODE_ID_AIM) {
            mode = 4;
        } else if (barcodeSettings == BarcodeConst.BarcodeSettings.CHARACTER_NONE) {
            mode = 5;
        } else if (barcodeSettings == BarcodeConst.BarcodeSettings.CHARACTER_GET) {
            mode = 6;
        } else if (barcodeSettings == BarcodeConst.BarcodeSettings.PREFIX_STATUS) {
            mode = 7;
        } else if (barcodeSettings == BarcodeConst.BarcodeSettings.TRIGGER_STANDARD) {
            mode = 8;
        } else if (barcodeSettings == BarcodeConst.BarcodeSettings.TRIGGER_PRESENTATION) {
            mode = 9;
        } else if (barcodeSettings == BarcodeConst.BarcodeSettings.PRESENTATION_GET) {
            mode = 10;
        }
        return mode;
    }

    private BarcodeConst.BarcodeSettings getModeBarcodeSettings(int mode) {
        BarcodeConst.BarcodeSettings barcodeSettings = BarcodeConst.BarcodeSettings.CHARACTER_NONE;
        if (mode == 0) {
            barcodeSettings = BarcodeConst.BarcodeSettings.DECODE_MODE_SINGLE;
        } else if (mode == 1) {
            barcodeSettings = BarcodeConst.BarcodeSettings.DECODE_MODE_CONTINUOUS;
        } else if (mode == 2) {
            barcodeSettings = BarcodeConst.BarcodeSettings.NOTIS_EDITING;
        } else if (mode == 3) {
            barcodeSettings = BarcodeConst.BarcodeSettings.CHARACTER_CODE_ID_SYMBOL;
        } else if (mode == 4) {
            barcodeSettings = BarcodeConst.BarcodeSettings.CHARACTER_CODE_ID_AIM;
        } else if (mode == 5) {
            barcodeSettings = BarcodeConst.BarcodeSettings.CHARACTER_NONE;
        } else if (mode == 6) {
            barcodeSettings = BarcodeConst.BarcodeSettings.CHARACTER_GET;
        } else if (mode == 7) {
            barcodeSettings = BarcodeConst.BarcodeSettings.PREFIX_STATUS;
        } else if (mode == 8) {
            barcodeSettings = BarcodeConst.BarcodeSettings.TRIGGER_STANDARD;
        } else if (mode == 9) {
            barcodeSettings = BarcodeConst.BarcodeSettings.TRIGGER_PRESENTATION;
        } else if (mode == 10) {
            barcodeSettings = BarcodeConst.BarcodeSettings.PRESENTATION_GET;
        }
        return barcodeSettings;
    }

    private int getMemoryTypeMode(BarcodeConst.MemoryType memoryType) {
        int mode = 0;
        if (memoryType == BarcodeConst.MemoryType.MEMORY_TYPE_TEMPORARY) {
            mode = 0;
        } else if (memoryType == BarcodeConst.MemoryType.MEMORY_TYPE_PERMANENT) {
            mode = 1;
        }
        return mode;
    }

    private BarcodeConst.MemoryType getModeMemoryType(int mode) {
        BarcodeConst.MemoryType memoryType = BarcodeConst.MemoryType.MEMORY_TYPE_TEMPORARY;
        if (mode == 0) {
            memoryType = BarcodeConst.MemoryType.MEMORY_TYPE_TEMPORARY;
        } else if (mode == 1) {
            memoryType = BarcodeConst.MemoryType.MEMORY_TYPE_PERMANENT;
        }
        return memoryType;
    }

    private int getSymbologyMode(Symbology symbology) {
        int mode = 0;
        if (symbology == Symbology.UPC_A) {
            mode = 0;
        } else if (symbology == Symbology.UPC_E) {
            mode = 1;
        } else if (symbology == Symbology.UPC_E1) {
            mode = 2;
        } else if (symbology == Symbology.EAN13_JAN13) {
            mode = 3;
        } else if (symbology == Symbology.EAN8_JAN8) {
            mode = 4;
        } else if (symbology == Symbology.BOOK_LAND_EAN) {
            mode = 5;
        } else if (symbology == Symbology.ISSN_EAN) {
            mode = 6;
        } else if (symbology == Symbology.INTERLEAVED_2_OF_5) {
            mode = 7;
        } else if (symbology == Symbology.DISCRETE_2_OF_5) {
            mode = 8;
        } else if (symbology == Symbology.CODA_BAR) {
            mode = 9;
        } else if (symbology == Symbology.CODE_128) {
            mode = 10;
        } else if (symbology == Symbology.CODE_39) {
            mode = 11;
        } else if (symbology == Symbology.CODE_93) {
            mode = 12;
        } else if (symbology == Symbology.CODE_11) {
            mode = 13;
        } else if (symbology == Symbology.MSI) {
            mode = 14;
        } else if (symbology == Symbology.CHINESE_2_OF_5) {
            mode = 15;
        } else if (symbology == Symbology.MATRIX_2_OF_5) {
            mode = 16;
        } else if (symbology == Symbology.KOREAN_2_OF_5) {
            mode = 17;
        } else if (symbology == Symbology.GS1_128) {
            mode = 18;
        } else if (symbology == Symbology.GS1_DATA_BAR) {
            mode = 19;
        } else if (symbology == Symbology.PDF_417) {
            mode = 20;
        } else if (symbology == Symbology.MACRO_PDF) {
            mode = 21;
        } else if (symbology == Symbology.DATA_MATRIX) {
            mode = 22;
        } else if (symbology == Symbology.GS1_DATA_MATRIX) {
            mode = 23;
        } else if (symbology == Symbology.QR_CODE) {
            mode = 24;
        } else if (symbology == Symbology.JAPAN_POSTAL) {
            mode = 25;
        } else if (symbology == Symbology.MICRO_QR_CODE) {
            mode = 26;
        } else if (symbology == Symbology.AZTEC) {
            mode = 27;
        } else if (symbology == Symbology.COMPOSITE_CC_C) {
            mode = 28;
        } else if (symbology == Symbology.COMPOSITE_CC_AB) {
            mode = 29;
        } else if (symbology == Symbology.COMPOSITE_TLC_39) {
            mode = 30;
        } else if (symbology == Symbology.MAXICODE) {
            mode = 31;
        } else if (symbology == Symbology.US_POSTNET) {
            mode = 32;
        } else if (symbology == Symbology.US_PLANET) {
            mode = 33;
        } else if (symbology == Symbology.UK_POSTAL) {
            mode = 34;
        } else if (symbology == Symbology.AUSTRALIA_POST) {
            mode = 35;
        } else if (symbology == Symbology.NETHERLAND_KIX_CODE) {
            mode = 36;
        }
        return mode;
    }

    private Symbology getModeSymbology(int mode) {
        Symbology symbology = Symbology.UPC_A;
        if (mode == 0) {
            symbology = Symbology.UPC_A;
        } else if (mode == 1) {
            symbology = Symbology.UPC_E;
        } else if (mode == 2) {
            symbology = Symbology.UPC_E1;
        } else if (mode == 3) {
            symbology = Symbology.EAN13_JAN13;
        } else if (mode == 4) {
            symbology = Symbology.EAN8_JAN8;
        } else if (mode == 5) {
            symbology = Symbology.BOOK_LAND_EAN;
        } else if (mode == 6) {
            symbology = Symbology.ISSN_EAN;
        } else if (mode == 7) {
            symbology = Symbology.INTERLEAVED_2_OF_5;
        } else if (mode == 8) {
            symbology = Symbology.DISCRETE_2_OF_5;
        } else if (mode == 9) {
            symbology = Symbology.CODA_BAR;
        } else if (mode == 10) {
            symbology = Symbology.CODE_128;
        } else if (mode == 11) {
            symbology = Symbology.CODE_39;
        } else if (mode == 12) {
            symbology = Symbology.CODE_93;
        } else if (mode == 13) {
            symbology = Symbology.CODE_11;
        } else if (mode == 14) {
            symbology = Symbology.MSI;
        } else if (mode == 15) {
            symbology = Symbology.CHINESE_2_OF_5;
        } else if (mode == 16) {
            symbology = Symbology.MATRIX_2_OF_5;
        } else if (mode == 17) {
            symbology = Symbology.KOREAN_2_OF_5;
        } else if (mode == 18) {
            symbology = Symbology.GS1_128;
        } else if (mode == 19) {
            symbology = Symbology.GS1_DATA_BAR;
        } else if (mode == 20) {
            symbology = Symbology.PDF_417;
        } else if (mode == 21) {
            symbology = Symbology.MACRO_PDF;
        } else if (mode == 22) {
            symbology = Symbology.DATA_MATRIX;
        } else if (mode == 23) {
            symbology = Symbology.GS1_DATA_MATRIX;
        } else if (mode == 24) {
            symbology = Symbology.QR_CODE;
        } else if (mode == 25) {
            symbology = Symbology.JAPAN_POSTAL;
        } else if (mode == 26) {
            symbology = Symbology.MICRO_QR_CODE;
        } else if (mode == 27) {
            symbology = Symbology.AZTEC;
        } else if (mode == 28) {
            symbology = Symbology.COMPOSITE_CC_C;
        } else if (mode == 29) {
            symbology = Symbology.COMPOSITE_CC_AB;
        } else if (mode == 30) {
            symbology = Symbology.COMPOSITE_TLC_39;
        } else if (mode == 31) {
            symbology = Symbology.MAXICODE;
        } else if (mode == 32) {
            symbology = Symbology.US_POSTNET;
        } else if (mode == 33) {
            symbology = Symbology.US_PLANET;
        } else if (mode == 34) {
            symbology = Symbology.UK_POSTAL;
        } else if (mode == 35) {
            symbology = Symbology.AUSTRALIA_POST;
        } else if (mode == 36) {
            symbology = Symbology.NETHERLAND_KIX_CODE;
        }
        return symbology;
    }
    private int getOCRMode(OCR ocr) {
        int mode = 0;
        if (ocr == OCR.OCR_A) {
            mode = 0;
        } else if (ocr == OCR.OCR_B) {
            mode = 1;
        }
        return mode;
    }

    private OCR getModeOCR(int mode) {
        OCR ocr = OCR.OCR_A;
        if (mode == 0) {
            ocr = OCR.OCR_A;
        } else if (mode == 1) {
            ocr = OCR.OCR_B;
        }
        return ocr;
    }

    private int getSystemBeepMode(BarcodeConst.SystemBeepSoundType type) {
        int mode = 0;
        if (type == BarcodeConst.SystemBeepSoundType.NONE) {
            mode = 0;
        } else if (type == BarcodeConst.SystemBeepSoundType.TYPE1) {
            mode = 1;
        } else if (type == BarcodeConst.SystemBeepSoundType.TYPE2) {
            mode = 2;
        } else if (type == BarcodeConst.SystemBeepSoundType.TYPE3) {
            mode = 3;
        } else if (type == BarcodeConst.SystemBeepSoundType.TYPE4) {
            mode = 4;
        } else if (type == BarcodeConst.SystemBeepSoundType.TYPE5) {
            mode = 5;
        } else if (type == BarcodeConst.SystemBeepSoundType.TYPE6) {
            mode = 6;
        } else if (type == BarcodeConst.SystemBeepSoundType.TYPE7) {
            mode = 7;
        } else if (type == BarcodeConst.SystemBeepSoundType.TYPE8) {
            mode = 8;
        }
        return mode;
    }

    private int getBarcodeCommandAction(BarcodeConst.BarcodeCommandAction type) {
        int event = 0;
        if (type == BarcodeConst.BarcodeCommandAction.UNSET) {
            event = 0;
        } else if (type == BarcodeConst.BarcodeCommandAction.GET_INFO_STOP_CONDITION) {
            event = 1;
        } else if (type == BarcodeConst.BarcodeCommandAction.GET_INFO_CHARACTER_STATUS) {
            event = 2;
        } else if (type == BarcodeConst.BarcodeCommandAction.GET_INFO_SYMBOLOGIES_ENABLE_STATUS) {
            event = 3;
        } else if (type == BarcodeConst.BarcodeCommandAction.GET_INFO_OCR_ENABLE_STATUS) {
            event = 4;
        } else if (type == BarcodeConst.BarcodeCommandAction.GET_INFO_SECURITY_LEVEL_ENABLE_STATUS) {
            event = 5;
        } else if (type == BarcodeConst.BarcodeCommandAction.GET_INFO_SCAN_DATA_TRANSMISSION_FORMAT) {
            event = 6;
        } else if (type == BarcodeConst.BarcodeCommandAction.GET_INFO_SYSTEM_BEEP) {
            event = 7;
        } else if (type == BarcodeConst.BarcodeCommandAction.GET_INFO_CODE_ID_ENABLE) {
            event = 8;
        } else if (type == BarcodeConst.BarcodeCommandAction.GET_INFO_NOTIS_EDITING) {
            event = 9;
        } else if (type == BarcodeConst.BarcodeCommandAction.GET_INFO_PRESENTATION_MODE) {
            event = 10;
        } else if (type == BarcodeConst.BarcodeCommandAction.SETTINGS_CHARACTER_STATUS) {
            event = 11;
        } else if (type == BarcodeConst.BarcodeCommandAction.SETTINGS_SYMBOLOGIES) {
            event = 12;
        } else if (type == BarcodeConst.BarcodeCommandAction.SETTING_OCR) {
            event = 13;
        } else if (type == BarcodeConst.BarcodeCommandAction.SETTING_SECURITY_LEVEL) {
            event = 14;
        } else if (type == BarcodeConst.BarcodeCommandAction.SETTINGS_SYSTEM_BEEP) {
            event = 15;
        } else if (type == BarcodeConst.BarcodeCommandAction.SETTINGS_NOTIS_EDITING) {
            event = 16;
        } else if (type == BarcodeConst.BarcodeCommandAction.SETTINGS_PRESENTATION_MODE) {
            event = 17;
        } else if (type == BarcodeConst.BarcodeCommandAction.FACTORY_DEFAULT) {
            event = 18;
        } else if (type == BarcodeConst.BarcodeCommandAction.FINISH) {
            event = 19;
        }
        return event;
    }

    private int getDeviceManagerError(AsReaderError.ErrorCode errorCode) {
        int event = 0;
        if (errorCode == AsReaderError.ErrorCode.NOT_SUPPORTED) {
            event = 0;
        } else if (errorCode == AsReaderError.ErrorCode.WITHOUT_AUTHORITY) {
            event = 1;
        } else if (errorCode == AsReaderError.ErrorCode.MEMORY_OVERRUN) {
            event = 2;
        } else if (errorCode == AsReaderError.ErrorCode.MEMORY_LOCKED) {
            event = 3;
        } else if (errorCode == AsReaderError.ErrorCode.CRYPTO_SUITE_ERROR) {
            event = 4;
        } else if (errorCode == AsReaderError.ErrorCode.COMMAND_NOT_ENCAPSULATED) {
            event = 5;
        } else if (errorCode == AsReaderError.ErrorCode.RESPONSE_BUFFER_OVERFLOW) {
            event = 6;
        } else if (errorCode == AsReaderError.ErrorCode.SECURITY_TIMEOUT) {
            event = 7;
        } else if (errorCode == AsReaderError.ErrorCode.INSUFFICIENT_POWER) {
            event = 8;
        } else if (errorCode == AsReaderError.ErrorCode.NON_SPECIFIC_ERROR) {
            event = 9;
        } else if (errorCode == AsReaderError.ErrorCode.ALREADY_POWER_ON) {
            event = 10;
        } else if (errorCode == AsReaderError.ErrorCode.FAILED_TO_SEND_PACKET) {
            event = 11;
        }
        return event;
    }

    private int getResult(BarcodeResult.Result result) {
        int event = 0;
        if (result == BarcodeResult.Result.UNKNOWN) {
            event = 0;
        } else if (result == BarcodeResult.Result.SYSTEM_BEEP_TYPE1) {
            event = 1;
        } else if (result == BarcodeResult.Result.SYSTEM_BEEP_TYPE2) {
            event = 2;
        } else if (result == BarcodeResult.Result.SYSTEM_BEEP_TYPE3) {
            event = 3;
        } else if (result == BarcodeResult.Result.SYSTEM_BEEP_TYPE4) {
            event = 4;
        } else if (result == BarcodeResult.Result.SYSTEM_BEEP_TYPE5) {
            event = 5;
        } else if (result == BarcodeResult.Result.SYSTEM_BEEP_TYPE6) {
            event = 6;
        } else if (result == BarcodeResult.Result.SYSTEM_BEEP_TYPE7) {
            event = 7;
        } else if (result == BarcodeResult.Result.SYSTEM_BEEP_TYPE8) {
            event = 8;
        } else if (result == BarcodeResult.Result.SYSTEM_BEEP_SOUND_NONE) {
            event = 9;
        } else if (result == BarcodeResult.Result.FACTORY_DEFAULT) {
            event = 10;
        } else if (result == BarcodeResult.Result.CHARACTER_NONE) {
            event = 11;
        } else if (result == BarcodeResult.Result.CHARACTER_SYMBOL) {
            event = 12;
        } else if (result == BarcodeResult.Result.CHARACTER_AIM) {
            event = 13;
        } else if (result == BarcodeResult.Result.STOP_CONDITIONS_CONTINUOUS_ON) {
            event = 14;
        } else if (result == BarcodeResult.Result.STOP_CONDITIONS_CONTINUOUS_OFF) {
            event = 15;
        } else if (result == BarcodeResult.Result.SYMBOLOGY_STATUS_GET) {
            event = 16;
        } else if (result == BarcodeResult.Result.SYMBOLOGY_STATUS_SET) {
            event = 17;
        } else if (result == BarcodeResult.Result.OCR_STATUS_GET) {
            event = 18;
        } else if (result == BarcodeResult.Result.OCR_STATUS_SET) {
            event = 19;
        } else if (result == BarcodeResult.Result.SECURITY_LEVEL_STATUS_GET) {
            event = 20;
        } else if (result == BarcodeResult.Result.SECURITY_LEVEL_STATUS_SET) {
            event = 21;
        } else if (result == BarcodeResult.Result.FORMAT_DATA_ONLY) {
            event = 22;
        } else if (result == BarcodeResult.Result.FORMAT_DATA_SUFFIX_TYPE1) {
            event = 23;
        } else if (result == BarcodeResult.Result.FORMAT_DATA_SUFFIX_TYPE2) {
            event = 24;
        } else if (result == BarcodeResult.Result.FORMAT_DATA_SUFFIX_TYPE3) {
            event = 25;
        } else if (result == BarcodeResult.Result.FORMAT_PREFIX_DATA) {
            event = 26;
        } else if (result == BarcodeResult.Result.FORMAT_PREFIX_DATA_SUFFIX_TYPE1) {
            event = 27;
        } else if (result == BarcodeResult.Result.FORMAT_PREFIX_DATA_SUFFIX_TYPE2) {
            event = 28;
        } else if (result == BarcodeResult.Result.FORMAT_PREFIX_DATA_SUFFIX_TYPE3) {
            event = 29;
        } else if (result == BarcodeResult.Result.NOTIS_EDITING_GET_ENABLED) {
            event = 30;
        } else if (result == BarcodeResult.Result.NOTIS_EDITING_GET_DISABLED) {
            event = 31;
        } else if (result == BarcodeResult.Result.PRESENTATION_SET) {
            event = 32;
        } else if (result == BarcodeResult.Result.PRESENTATION_GET_ENABLED) {
            event = 33;
        } else if (result == BarcodeResult.Result.PRESENTATION_GET_DISABLED) {
            event = 34;
        }
        return event;
    }
}

