/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.devicemanager;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.asterisk.asreader.a24d.communicationmanager.CommunicationDeviceCallback;
import jp.co.asterisk.asreader.a24d.communicationmanager.CommunicationManager;
import jp.co.asterisk.asreader.a24d.communicationmanager.connection.ConnectionType;
import jp.co.asterisk.asreader.a24d.communicationmanager.packet.AsReaderPacketConst;
import jp.co.asterisk.asreader.a24d.communicationmanager.packet.PacketModel;
import jp.co.asterisk.asreader.a24d.utility.AsReaderError;
import jp.co.asterisk.asreader.a24d.utility.LogLevel;
import jp.co.asterisk.asreader.a24d.utility.SDKLog;
import jp.co.asterisk.asreader.a24d.utility.SDKSharedData;
import jp.co.asterisk.asreader.devicemanager.DeviceCommandFactory;
import jp.co.asterisk.asreader.devicemanager.DeviceConst;
import jp.co.asterisk.asreader.devicemanager.DeviceManagerCallback;

public class DeviceManager
implements CommunicationDeviceCallback {
    private static DeviceManager mInstance = null;
    private static final String TAG = "[AsReaderSDK] " + DeviceManager.class.getSimpleName();
    private final String ACTION_USB_PERMISSION = "jp.co.asterisk.asreader.communicationmanager.connection.usb.USBManager.USB_PERMISSION";
    private DeviceManagerCallback callback;
    private static final String KEY_TRIGGER_MODE = "Key_TriggerMode";
    private boolean isConnected;
    private boolean isLedOn = true;
    private boolean isActive = false;
    private Context mContext = null;
    private String mPackageName = "";
    private MyActivityLifecycleCallbacks activityLifecycleCallback;
    private ConnectionControlMode mConnectionControlMode = ConnectionControlMode.SDK;
    private ConnectionType connectionType;
    private final String KEY_BACKGROUND_READ_ENABLED = "KEY_BACKGROUND_READ_ENABLED";
    private boolean isBackgroundReadEnabled = SDKSharedData.getInstance().getBoolean("KEY_BACKGROUND_READ_ENABLED", false);
    BroadcastReceiver usbReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (DeviceManager.this.mConnectionControlMode == ConnectionControlMode.SDK) {
                if ("jp.co.asterisk.asreader.communicationmanager.connection.usb.USBManager.USB_PERMISSION".equals(action)) {
                    if (intent.getBooleanExtra("permission", false)) {
                        DeviceManager.this.open();
                    }
                } else if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                    if (DeviceManager.this.isActive) {
                        DeviceManager.this.open();
                    }
                } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action) && DeviceManager.this.isActive) {
                    DeviceManager.this.close();
                }
            }
        }
    };

    private DeviceManager() {
    }

    public static DeviceManager getInstance() {
        if (mInstance == null) {
            mInstance = new DeviceManager();
        }
        return mInstance;
    }

    public void setPackageName(String name) {
        this.mPackageName = name;
    }

    public void setCallback(DeviceManagerCallback callback) {
        this.callback = callback;
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "Device manager callback set");
    }

    public void setConnectionControlMode(ConnectionControlMode mode) {
        this.mConnectionControlMode = mode;
    }

    public ConnectionControlMode getConnectionControlMode() {
        return this.mConnectionControlMode;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setTriggerMode(DeviceConst.TriggerMode mode) {
        SDKSharedData.getInstance().putString(KEY_TRIGGER_MODE, mode.toString());
    }

    public DeviceConst.TriggerMode getTriggerMode() {
        String mode = SDKSharedData.getInstance().getString(KEY_TRIGGER_MODE, DeviceConst.TriggerMode.AUTO.toString());
        return DeviceConst.TriggerMode.valueOf(mode);
    }

    public boolean getBackgroundRead() {
        return this.isBackgroundReadEnabled;
    }

    public void initialize(Context context, ConnectionType selectConnection) {
        this.connectionType = selectConnection;
        IntentFilter filter = new IntentFilter("jp.co.asterisk.asreader.communicationmanager.connection.usb.USBManager.USB_PERMISSION");
        filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        ContextCompat.registerReceiver((Context)context, (BroadcastReceiver)this.usbReceiver, (IntentFilter)filter, (int)2);
        this.mContext = context;
        if (context.getApplicationContext() instanceof Application) {
            this.activityLifecycleCallback = new MyActivityLifecycleCallbacks();
            ((Application)context.getApplicationContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycleCallback);
            if (this.getAppProcessStatus(this.mContext) == ActivityStatus.FOREGROUND) {
                this.isActive = true;
            }
        }
        CommunicationManager.getInstance().setCommunicationDeviceCallback((CommunicationDeviceCallback)this);
    }

    public boolean isOpen() {
        return CommunicationManager.getInstance().isOpen();
    }

    public void open() {
        if (this.connectionType != ConnectionType.USB) {
            return;
        }
        String pkName = this.mContext.getPackageName();
        if (!pkName.equals(this.mPackageName) || !this.isActive) {
            return;
        }
        if (!CommunicationManager.getInstance().isOpen()) {
            CommunicationManager.getInstance().open();
            this.isConnected = CommunicationManager.getInstance().isOpen();
            if (this.isConnected && this.callback != null) {
                this.callback.onConnect(true);
            }
        }
        this.isConnected = CommunicationManager.getInstance().isOpen();
        CommunicationManager.getInstance().connectedStatus(this.isConnected);
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "Open connect = " + this.isConnected);
    }

    public void open(BluetoothDevice bluetoothDevice) {
        if (this.connectionType != ConnectionType.BLE) {
            return;
        }
        if (!CommunicationManager.getInstance().isOpen()) {
            CommunicationManager.getInstance().open(bluetoothDevice);
            this.isConnected = CommunicationManager.getInstance().isOpen();
            if (this.isConnected && this.callback != null) {
                this.callback.onConnect(true);
            }
        } else {
            this.isConnected = true;
        }
        CommunicationManager.getInstance().connectedStatus(this.isConnected);
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "Open connect = " + this.isConnected);
    }

    public void close() {
        if (CommunicationManager.getInstance().isOpen()) {
            CommunicationManager.getInstance().close();
            this.isConnected = CommunicationManager.getInstance().isOpen();
            if (!this.isConnected && this.callback != null) {
                this.callback.onConnect(false);
            }
        }
        this.isConnected = false;
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "Close connect = " + this.isConnected);
    }

    public void setReaderSettings(boolean beep, boolean vib, boolean aimer, boolean led, boolean powerOnBeep) {
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "DeviceManager setReaderSettings: beep=" + beep + " vib=" + vib + " aimer=" + aimer + "led=" + led + " power on beep=" + powerOnBeep);
        this.isLedOn = led;
        PacketModel packetModel = DeviceCommandFactory.getInstance().create(DeviceConst.DeviceCommandType.SET_READER_SETTING);
        packetModel.addPayload(beep ? (byte)-1 : 0);
        packetModel.addPayload(vib ? (byte)-1 : 0);
        packetModel.addPayload(aimer ? (byte)-1 : 0);
        packetModel.addPayload(led ? (byte)-1 : 0);
        packetModel.addPayload(powerOnBeep ? (byte)-1 : 0);
        packetModel.updateLength();
        this.sendPacket(packetModel);
    }

    public void getReaderSettings() {
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "DeviceManager getReaderSettings");
        PacketModel packetModel = DeviceCommandFactory.getInstance().create(DeviceConst.DeviceCommandType.GET_READER_SETTING);
        this.sendPacket(packetModel);
    }

    public void getReaderInfo() {
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "DeviceManager getReaderInfo");
        PacketModel packetModel = DeviceCommandFactory.getInstance().create(DeviceConst.DeviceCommandType.READER_INFO);
        this.sendPacket(packetModel);
    }

    public void getSleepTime() {
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "DeviceManager getSleepTime");
        PacketModel packetModel = DeviceCommandFactory.getInstance().create(DeviceConst.DeviceCommandType.GET_SLEEP_TIME);
        this.sendPacket(packetModel);
    }

    public void setSleepTime(@IntRange(from=0L, to=255L) int sleepTime) {
        if (sleepTime < 0 || sleepTime > 255) {
            return;
        }
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "DeviceManager setSleepTime");
        PacketModel packetModel = DeviceCommandFactory.getInstance().create(DeviceConst.DeviceCommandType.SET_SLEEP_TIME);
        packetModel.addPayload((byte)sleepTime);
        packetModel.updateLength();
        this.sendPacket(packetModel);
    }

    public void getSleepBeep() {
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "DeviceManager getSleepBeep");
        PacketModel packetModel = DeviceCommandFactory.getInstance().create(DeviceConst.DeviceCommandType.GET_SLEEP_BEEP);
        this.sendPacket(packetModel);
    }

    public void setSleepBeep(boolean isSleepBeepOn) {
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "DeviceManager setSleepBeep");
        PacketModel packetModel = DeviceCommandFactory.getInstance().create(DeviceConst.DeviceCommandType.SET_SLEEP_BEEP);
        packetModel.addPayload(isSleepBeepOn ? (byte)1 : 0);
        packetModel.updateLength();
        this.sendPacket(packetModel);
    }

    public void getSleepTimeAndBeep() {
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "DeviceManager getSleepTimeAndBeep");
        PacketModel packetModel = DeviceCommandFactory.getInstance().create(DeviceConst.DeviceCommandType.GET_SLEEP_TIME_AND_BEEP);
        this.sendPacket(packetModel);
    }

    public void setSleepTimeAndBeep(@IntRange(from=0L, to=255L) int sleepTime, boolean isSleepBeepOn) {
        if (sleepTime < 0 || sleepTime > 255) {
            return;
        }
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "DeviceManager setSleepBeep");
        PacketModel packetModel = DeviceCommandFactory.getInstance().create(DeviceConst.DeviceCommandType.SET_SLEEP_TIME_AND_BEEP);
        packetModel.addPayload((byte)sleepTime);
        packetModel.addPayload(isSleepBeepOn ? (byte)1 : 0);
        packetModel.updateLength();
        this.sendPacket(packetModel);
    }

    public void setHIDMode(DeviceConst.HIDType hid) {
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "DeviceManager setHIDMode");
        PacketModel packetModel = DeviceCommandFactory.getInstance().create(DeviceConst.DeviceCommandType.SET_HID_MODE);
        byte data = 0;
        switch (hid) {
            case ANDROID_HID: {
                data = -1;
                break;
            }
            case IOS_HID: {
                data = -2;
                break;
            }
        }
        packetModel.setPayload(new byte[]{0, data});
        this.sendPacket(packetModel);
    }

    public void getHIDMode() {
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "DeviceManager getHIDMode");
        PacketModel packetModel = DeviceCommandFactory.getInstance().create(DeviceConst.DeviceCommandType.GET_HID_MODE);
        packetModel.setPayload(new byte[]{1, 0});
        this.sendPacket(packetModel);
    }

    public void rebootTheDevice() {
        PacketModel packetModel = new PacketModel();
        packetModel.setCommand(AsReaderPacketConst.AsReaderPacket.MESSAGE.getByte(), (byte)8, null);
        this.sendPacket(packetModel);
    }

    private ActivityStatus getAppProcessStatus(Context context) {
        if (this.isForeground(context)) {
            return ActivityStatus.FOREGROUND;
        }
        return ActivityStatus.BACKGROUND;
    }

    private boolean isForeground(Context context) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        List appList = manager.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo processInfo : appList) {
            if (processInfo.importance != 100) continue;
            return true;
        }
        return false;
    }

    private void sendPacket(PacketModel packetModel) {
        SDKLog.getInstance().Log(TAG, LogLevel.Debug, "DeviceManager sendPacket");
        if (!CommunicationManager.getInstance().sendPacket(packetModel)) {
            SDKLog.getInstance().Log(TAG, LogLevel.Error, "DeviceManager Failed to send packet.");
            this.callback.onDeviceManagerError(AsReaderError.ErrorCode.FAILED_TO_SEND_PACKET);
        }
    }

    private void sendPacketNotCRC(PacketModel packetModel) {
        SDKLog.getInstance().Log(TAG, LogLevel.Debug, "DeviceManager sendPacket");
        if (!CommunicationManager.getInstance().sendPacketNotCRC(packetModel)) {
            SDKLog.getInstance().Log(TAG, LogLevel.Error, "DeviceManager Failed to send packet.");
            this.callback.onDeviceManagerError(AsReaderError.ErrorCode.FAILED_TO_SEND_PACKET);
        }
    }

    private Map<String, String> createReaderInfoMap(int[] data) {
        HashMap<String, String> map = new HashMap<String, String>();
        char[] tempChar = new char[data.length];
        for (int i = 0; i < data.length; ++i) {
            tempChar[i] = (char)data[i];
        }
        if (data.length > 30 && data[0] == 178) {
            StringBuilder info = new StringBuilder();
            for (int dataValue : data) {
                info.append((char)dataValue);
            }
            String[] splitData = info.toString().split(",");
            map.put("KeyInfo_ModelName", splitData[0].substring(1));
            map.put("KeyInfo_HardwareVersion", splitData[1]);
            map.put("KeyInfo_FirmwareVersion", splitData[2]);
        }
        return map;
    }

    private Map<String, String> createSleepParameterMap(int[] data) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (data[1] == 2) {
            map.put("KeyParameter_SleepTime", String.valueOf(data[2]));
            map.put("KeyParameter_SleepBeep", data[3] == 1 ? "true" : "false");
        }
        if (data[1] == 1) {
            if (data[0] == 0) {
                map.put("KeyParameter_SleepTime", String.valueOf(data[2]));
            }
            if (data[0] == 1) {
                map.put("KeyParameter_SleepBeep", data[2] == 1 ? "true" : "false");
            }
        }
        return map;
    }

    private Map<String, Boolean> createSettingParameterMap(int[] data) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("KeyParameter_ScanBeep", data[0] != 0);
        map.put("KeyParameter_ScanVibration", data[1] != 0);
        map.put("KeyParameter_ScanAimer", data[2] != 0);
        map.put("KeyParameter_LED", data[3] != 0);
        if (data.length >= 5) {
            map.put("KeyParameter_PowerBeep", data[4] != 0);
        }
        this.isLedOn = data[3] != 0;
        return map;
    }

    public void onReceivedData(PacketModel packetModel) {
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "onReceivedData");
        byte[] payload = packetModel.getPayload();
        int[] data = new int[payload.length];
        for (int i = 0; i < payload.length; ++i) {
            data[i] = payload[i] & 0xFF;
        }
        AsReaderPacketConst.AsReaderPacket packet = AsReaderPacketConst.getAsReaderPacket((byte)packetModel.getCommand());
        switch (packet) {
            case CMD_BATTERY_STATUS: {
                int battery;
                if (this.callback == null) break;
                int adc = data[0];
                int adcMin = data[1];
                int adcMax = data[2];
                if (adcMin == adcMax) {
                    ++adcMax;
                }
                if ((battery = (adc - adcMin) * 100 / (adcMax - adcMin)) > 100) {
                    battery = 100;
                } else if (battery < 0) {
                    battery = 0;
                }
                this.callback.onBatteryStateReceived(battery);
                break;
            }
            case CMD_TRIGGER_EVENT: {
                if (this.callback == null) break;
                DeviceConst.DeviceTriggerEvent event = DeviceConst.DeviceTriggerEvent.PUSH_NONE;
                if (data[0] == 1) {
                    event = DeviceConst.DeviceTriggerEvent.PUSH_RIGHT;
                } else if (data[1] == 1) {
                    event = DeviceConst.DeviceTriggerEvent.PUSH_LEFT;
                }
                if (this.getTriggerMode() == DeviceConst.TriggerMode.MANUAL) {
                    this.callback.onTriggerEventReceived(event);
                    break;
                }
                boolean execute = event != DeviceConst.DeviceTriggerEvent.PUSH_NONE;
                CommunicationManager.getInstance().executeTriggerAutoMode(execute);
                break;
            }
            case CMD_GET_READER_INFO: {
                if (this.callback == null) break;
                Map<String, String> readerInfoMap = this.createReaderInfoMap(data);
                this.callback.onReaderInfoReceived(readerInfoMap);
                break;
            }
            case CMD_SET_DEVICE_SETTINGS: {
                this.callback.onSetReaderSettingSuccess();
                break;
            }
            case CMD_GET_DEVICE_SETTINGS: {
                Map<String, Boolean> settingParamMap = this.createSettingParameterMap(data);
                this.callback.onReaderSettingReceived(settingParamMap);
                break;
            }
            case CMD_HID_MODE: {
                if (data[1] == 0) {
                    this.callback.onHIDModeReceived(DeviceConst.HIDType.HID_OFF);
                    break;
                }
                if (data[1] == 254) {
                    this.callback.onHIDModeReceived(DeviceConst.HIDType.IOS_HID);
                    break;
                }
                if (data[1] != 255) break;
                this.callback.onHIDModeReceived(DeviceConst.HIDType.ANDROID_HID);
                break;
            }
            case CMD_GET_MODULE_SLEEP_SETTING: {
                Map<String, String> sleepParamMap = this.createSleepParameterMap(data);
                this.callback.onSleepSettingReceived(sleepParamMap);
                break;
            }
            case CMD_SET_MODULE_SLEEP_SETTING: {
                break;
            }
            case CMD_SET_CHARGE_CONTROL: {
                this.callback.onSetChargeControlSuccess();
                break;
            }
            case CMD_FAILED: {
                if (payload.length < 3) {
                    this.callback.onDeviceManagerError(AsReaderError.ErrorCode.NON_SPECIFIC_ERROR);
                }
                if (data[1] == 1) {
                    this.callback.onDeviceManagerError(AsReaderError.ErrorCode.ALREADY_POWER_ON);
                    return;
                }
                if (data[1] == 186) {
                    this.callback.onHIDModeReceived(DeviceConst.HIDType.NOT_APPLICABLE);
                    return;
                }
                AsReaderError.ErrorCode errCode = AsReaderError.getError((byte)payload[2]);
                this.callback.onDeviceManagerError(errCode);
            }
        }
    }

    public void onReceivedBLEConnection(boolean connected) {
        if (this.getAppProcessStatus(this.mContext) == ActivityStatus.FOREGROUND) {
            boolean isOpen;
            this.isConnected = isOpen = CommunicationManager.getInstance().isOpen();
            if (this.callback != null && connected == isOpen) {
                this.callback.onConnect(connected);
            }
        }
    }

    private class MyActivityLifecycleCallbacks
    implements Application.ActivityLifecycleCallbacks {
        private MyActivityLifecycleCallbacks() {
        }

        public void onActivityStarted(@NonNull Activity activity) {
            DeviceManager.this.isActive = true;
            if (DeviceManager.this.mConnectionControlMode == ConnectionControlMode.SDK) {
                DeviceManager.this.open();
            }
            SDKLog.getInstance().open();
        }

        public void onActivityStopped(@NonNull Activity activity) {
            SDKLog.getInstance().Log(TAG, LogLevel.Information, "ActivityStatus = " + (Object)((Object)DeviceManager.this.getAppProcessStatus(DeviceManager.this.mContext)));
            if (DeviceManager.this.getAppProcessStatus(DeviceManager.this.mContext) == ActivityStatus.BACKGROUND) {
                DeviceManager.this.isActive = false;
                if (CommunicationManager.getInstance().isOpen() && DeviceManager.this.mConnectionControlMode == ConnectionControlMode.SDK && DeviceManager.this.connectionType != ConnectionType.BLE && !DeviceManager.this.isBackgroundReadEnabled) {
                    DeviceManager.this.close();
                }
                SDKLog.getInstance().close();
            }
        }

        public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        }

        public void onActivityResumed(@NonNull Activity activity) {
        }

        public void onActivityPaused(@NonNull Activity activity) {
        }

        public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
        }

        public void onActivityDestroyed(@NonNull Activity activity) {
        }
    }

    public static enum ConnectionControlMode {
        SDK,
        USER;

    }

    private static enum ActivityStatus {
        FOREGROUND,
        BACKGROUND,
        GONE;

    }
}

