/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a24d.communicationmanager.packet;

import java.util.ArrayList;
import jp.co.asterisk.asreader.a24d.communicationmanager.packet.CRCCalculator;

public class PacketModel {
    private static final byte PREANBLE = -69;
    private static final byte ENDMARK = 126;
    private byte mPreamble = (byte)-69;
    private byte mType;
    private byte mCommand;
    private byte[] mLength;
    private ArrayList<Byte> mPayload;
    private byte mEndMark = (byte)126;
    private byte[] mCRC;

    public PacketModel() {
        this.mLength = new byte[2];
        this.mPayload = new ArrayList();
        this.mCRC = new byte[2];
    }

    public void setCommand(byte type, byte command, byte[] payload) {
        this.mType = type;
        this.mCommand = command;
        if (payload != null) {
            this.setPayload(payload);
            int length = payload != null ? payload.length : 0;
            this.mLength[0] = (byte)(length >> 8 & 0xFF);
            this.mLength[1] = (byte)(length & 0xFF);
        }
    }

    public void updateLength() {
        int length = 0;
        if (this.mPayload != null && this.mPayload.size() > 0) {
            length = this.mPayload.size();
        }
        this.mLength[0] = (byte)(length >> 8 & 0xFF);
        this.mLength[1] = (byte)(length & 0xFF);
    }

    public byte[] getByte(byte[] retPacket) {
        return retPacket;
    }

    public byte[] toByteArray() {
        int size = 8;
        int n = this.mPayload != null ? this.mPayload.size() : 0;
        int count = 0;
        byte[] data = new byte[size += n];
        data[count++] = this.mPreamble;
        data[count++] = this.mType;
        data[count++] = this.mCommand;
        data[count++] = this.mLength[0];
        data[count++] = this.mLength[1];
        if (this.mPayload != null) {
            for (Byte buf : this.mPayload) {
                data[count++] = buf;
            }
        }
        data[count++] = this.mEndMark;
        data[count++] = this.mCRC[0];
        data[count] = this.mCRC[1];
        return data;
    }

    public byte[] toByteArrayNotCRC() {
        int size = 6;
        int n = this.mPayload != null ? this.mPayload.size() : 0;
        int count = 0;
        byte[] data = new byte[size += n];
        data[count++] = this.mPreamble;
        data[count++] = this.mType;
        data[count++] = this.mCommand;
        data[count++] = this.mLength[0];
        data[count++] = this.mLength[1];
        if (this.mPayload != null) {
            for (Byte buf : this.mPayload) {
                data[count++] = buf;
            }
        }
        data[count++] = this.mEndMark;
        return data;
    }

    public void makeCRC() {
        int size = 5;
        int n = this.mPayload != null ? this.mPayload.size() : 0;
        int count = 0;
        byte[] data = new byte[size += n];
        data[count++] = this.mType;
        data[count++] = this.mCommand;
        data[count++] = this.mLength[0];
        data[count++] = this.mLength[1];
        if (this.mPayload != null) {
            for (Byte buf : this.mPayload) {
                data[count++] = buf;
            }
        }
        data[count] = this.mEndMark;
        int crc = CRCCalculator.Cal_CRC16(data);
        this.mCRC[0] = (byte)(crc >> 8 & 0xFF);
        this.mCRC[1] = (byte)(crc & 0xFF);
    }

    public byte[] getPayload() {
        if (this.mPayload == null || this.mPayload.size() <= 0) {
            return null;
        }
        int payloadLength = this.getLength();
        byte[] actualPayload = new byte[payloadLength];
        for (int i = 0; i < payloadLength; ++i) {
            Byte buf = this.mPayload.get(i);
            actualPayload[i] = buf;
        }
        return actualPayload;
    }

    public void addPayload(byte data) {
        this.mPayload.add(data);
    }

    public void setPayload(byte[] bytes) {
        this.mPayload.clear();
        if (bytes == null) {
            return;
        }
        for (byte buf : bytes) {
            this.mPayload.add(buf);
        }
        this.updateLength();
    }

    public void setPreamble(byte mPreamble) {
        this.mPreamble = mPreamble;
    }

    public void setType(byte mType) {
        this.mType = mType;
    }

    public byte getCommand() {
        return this.mCommand;
    }

    public void setCommand(byte mCommand) {
        this.mCommand = mCommand;
    }

    public void setLength(byte[] mLength) {
        this.mLength = mLength;
    }

    public int getLength() {
        return (this.mLength[0] << 8 & 0xFF00) + (this.mLength[1] & 0xFF);
    }

    public void setEndMark(byte mEndMark) {
        this.mEndMark = mEndMark;
    }

    public void setCRC(byte[] mCRC) {
        this.mCRC = mCRC;
    }

    public String getPacketString() {
        String retStr = "";
        for (byte buf : this.mPayload) {
            retStr = retStr + String.format("%02X", buf) + " ";
        }
        return retStr;
    }
}

