/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a24d.communicationmanager.connection.usb;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.hardware.usb.UsbRequest;
import android.util.Log;
import java.nio.ByteBuffer;
import jp.co.asterisk.asreader.a24d.communicationmanager.connection.ConnectionCallback;
import jp.co.asterisk.asreader.a24d.utility.LogLevel;
import jp.co.asterisk.asreader.a24d.utility.SDKLog;

public class USBManager {
    private static USBManager instance;
    private final String TAG = "\u3010AsReaderSDK\u3011" + USBManager.class.getSimpleName();
    private final String ACTION_USB_PERMISSION = "jp.co.asterisk.asreader.communicationmanager.connection.usb.USBManager.USB_PERMISSION";
    private final int USB_RECIP_INTERFACE = 1;
    private final int USB_RT_ACM = 33;
    private final int SET_LINE_CODING = 32;
    private final int GET_LINE_CODING = 33;
    private final int SET_CONTROL_LINE_STATE = 34;
    private final int USB_DEVICE_CDC_CONTROL_SIG_BITMAP_CARRIER_ACTIVATION = 2;
    private final int USB_DEVICE_CDC_CONTROL_SIG_BITMAP_DTE_PRESENCE = 1;
    private final int CONTROL_TRANSFER_TIMEOUT = 5000;
    private final int TX_TIMEOUT = 100;
    private Context context;
    private UsbManager usbManager;
    private UsbDevice usbDevice;
    private UsbDeviceConnection usbDeviceConnection;
    private UsbEndpoint endpointIn;
    private UsbEndpoint endpointOut;
    private UsbInterface interfaceControl;
    private UsbInterface interfaceData;
    private Thread rxThread;
    private boolean isOpen = false;
    private ConnectionCallback callback;
    private final Runnable inputProcessor = () -> {
        ByteBuffer buffer = ByteBuffer.allocate(5000);
        UsbRequest request = new UsbRequest();
        request.initialize(this.usbDeviceConnection, this.endpointIn);
        while (this.isOpen) {
            request.queue(buffer);
            UsbRequest response = this.usbDeviceConnection.requestWait();
            if (response == null) {
                return;
            }
            int bufferPos = buffer.position();
            if (bufferPos > 0) {
                byte[] bytes = new byte[buffer.position()];
                buffer.flip();
                buffer.get(bytes);
                this.callback.onReceivedData(bytes);
            }
            buffer.clear();
        }
        request.close();
        this.rxThread = null;
        USBManager uSBManager = this;
        synchronized (uSBManager) {
            this.notifyAll();
        }
        Log.d((String)this.TAG, (String)"RX Thread Finish");
    };

    private USBManager() {
    }

    public void setCallback(ConnectionCallback callback) {
        this.callback = callback;
    }

    public static USBManager getInstance() {
        if (instance == null) {
            instance = new USBManager();
        }
        return instance;
    }

    public boolean isOpen() {
        if (this.usbDevice == null) {
            this.isOpen = false;
        }
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "isOpen : " + this.isOpen);
        return this.isOpen;
    }

    public void initialize(Context context) {
        this.context = context;
        this.usbManager = (UsbManager)context.getSystemService("usb");
    }

    public void open() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "USB Open");
        if (this.usbDevice == null) {
            this.openUsbDevice();
        }
    }

    public void close() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "USB Close");
        this.isOpen = false;
        if (this.usbDeviceConnection != null) {
            this.disableUSBDevice(this.usbDeviceConnection);
            this.usbDeviceConnection.close();
            this.usbDeviceConnection = null;
        }
        if (this.rxThread != null) {
            try {
                this.rxThread.join(50L);
            }
            catch (InterruptedException ex) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "rxThread has not finished.");
                this.rxThread.interrupt();
            }
            this.rxThread = null;
        }
        this.usbDevice = null;
        this.usbManager = null;
    }

    public boolean sendData(byte[] buffer) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "sendData");
        if (!this.isOpen) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Warning, "sendData: isOpen is false.");
            return false;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < buffer.length; ++i) {
            sb.append(String.format("%02X ", buffer[i]));
        }
        if (this.usbDeviceConnection.bulkTransfer(this.endpointOut, buffer, buffer.length, 100) > 0) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "bulkTransfer send :\u3000" + sb.toString());
        } else {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "bulkTransfer failed :  " + sb.toString());
        }
        return true;
    }

    private void openUsbDevice() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "openUsbDevice");
        this.usbDevice = this.getDevice();
        if (this.usbDevice == null) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "UsbDevice open fail.");
            return;
        }
        if (!this.usbManager.hasPermission(this.usbDevice)) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "UsbDevice permission request.");
            this.requestPermission();
            this.usbDevice = null;
            return;
        }
        if (!this.searchInterface()) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "USBInterfaces not found.");
            this.usbDevice = null;
            return;
        }
        this.usbDeviceConnection = this.usbManager.openDevice(this.usbDevice);
        this.enableUSBDevice();
        this.setUART(115200);
        this.endpointIn = this.getEndPoint(128);
        this.endpointOut = this.getEndPoint(0);
        if (this.endpointIn != null && this.endpointOut != null) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "USB Open");
            this.isOpen = true;
            if (this.rxThread == null) {
                this.rxThread = new Thread(this.inputProcessor);
                this.rxThread.start();
            }
        } else {
            this.usbDevice = null;
        }
    }

    private void requestPermission() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "Start request permission.");
        Intent intent = new Intent("jp.co.asterisk.asreader.communicationmanager.connection.usb.USBManager.USB_PERMISSION");
        intent.setPackage(this.context.getPackageName());
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.context.getApplicationContext(), (int)0, (Intent)intent, (int)0x2000000);
        this.usbManager.requestPermission(this.usbDevice, pendingIntent);
    }

    private UsbDevice getDevice() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "getDevice");
        if (this.usbDevice == null) {
            if (this.usbManager == null) {
                this.usbManager = (UsbManager)this.context.getSystemService("usb");
            }
            if (!this.usbManager.getDeviceList().isEmpty()) {
                for (UsbDevice object : this.usbManager.getDeviceList().values()) {
                    if (object.getVendorId() != 10473 && object.getVendorId() != 13212) continue;
                    this.usbDevice = object;
                    break;
                }
            }
        }
        return this.usbDevice;
    }

    private boolean searchInterface() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "searchInterface");
        this.interfaceControl = this.getInterface(2);
        this.interfaceData = this.getInterface(10);
        return this.interfaceControl != null && this.interfaceData != null;
    }

    private UsbInterface getInterface(int interfaceClass) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "getInterface");
        for (int i = 0; i < this.usbDevice.getInterfaceCount(); ++i) {
            Log.d((String)this.TAG, (String)("usbDevice.getControlInterface(i).getInterfaceClass() =" + this.usbDevice.getInterface(i).getInterfaceClass()));
            if (this.usbDevice.getInterface(i).getInterfaceClass() != interfaceClass) continue;
            return this.usbDevice.getInterface(i);
        }
        return null;
    }

    private int setAcmControlMessage(int request, int value, byte[] buffer) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "setAcmControlMessage");
        if (this.usbDeviceConnection != null) {
            int requestType = 33;
            int index = this.interfaceControl != null ? this.interfaceControl.getId() : 0;
            int length = buffer != null ? buffer.length : 0;
            return this.usbDeviceConnection.controlTransfer(requestType, request, value, index, buffer, length, 5000);
        }
        return 0;
    }

    private int getACMControlMessage(int request, int value, byte[] buffer) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "getACMControlMessage");
        if (this.usbDeviceConnection != null) {
            int requestType = 161;
            int index = this.interfaceControl != null ? this.interfaceControl.getId() : 0;
            int length = buffer != null ? buffer.length : 0;
            return this.usbDeviceConnection.controlTransfer(requestType, request, value, index, buffer, length, 5000);
        }
        return 0;
    }

    private boolean enableUSBDevice() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "enableUSBDevice");
        if (!this.usbDeviceConnection.claimInterface(this.interfaceControl, true) || !this.usbDeviceConnection.claimInterface(this.interfaceData, true)) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "claimInterface is fail.");
            return false;
        }
        byte[] data = new byte[7];
        this.getACMControlMessage(33, 0, data);
        int baudRate = data[0] & 0xFF;
        baudRate |= (data[1] & 0xFF) << 8;
        baudRate |= (data[2] & 0xFF) << 16;
        byte format = data[4];
        byte parity = data[5];
        byte bits = data[6];
        Log.d((String)this.TAG, (String)((baudRate |= (data[3] & 0xFF) << 24) + "bps," + format + "," + parity + "," + bits));
        int value = 3;
        this.setAcmControlMessage(34, value, null);
        return true;
    }

    private void disableUSBDevice(UsbDeviceConnection connection) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "disableUSBDevice");
        int value = 2;
        this.setAcmControlMessage(34, value, null);
        if (this.interfaceControl != null) {
            connection.releaseInterface(this.interfaceControl);
        }
        if (this.interfaceData != null) {
            connection.releaseInterface(this.interfaceData);
        }
    }

    private void setUART(int baudrate) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "setUART");
        byte[] data = new byte[]{(byte)(baudrate & 0xFF), (byte)(baudrate >> 8 & 0xFF), (byte)(baudrate >> 16 & 0xFF), (byte)(baudrate >> 24 & 0xFF), 0, 0, 8};
        this.setAcmControlMessage(32, 0, data);
    }

    private UsbEndpoint getEndPoint(int direction) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "getEndPoint");
        for (int i = 0; i < this.interfaceData.getEndpointCount(); ++i) {
            if (this.interfaceData.getEndpoint(i).getType() != 2 || this.interfaceData.getEndpoint(i).getDirection() != direction) continue;
            return this.interfaceData.getEndpoint(i);
        }
        return null;
    }
}

