/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a24d.communicationmanager.connection.ble;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import jp.co.asterisk.asreader.a24d.communicationmanager.connection.ble.BLEScanCallback;
import no.nordicsemi.android.support.v18.scanner.BluetoothLeScannerCompat;
import no.nordicsemi.android.support.v18.scanner.ScanCallback;
import no.nordicsemi.android.support.v18.scanner.ScanResult;
import no.nordicsemi.android.support.v18.scanner.ScanSettings;

public class BLEScanManager {
    private static BLEScanManager instance;
    private BLEScanCallback bleCallback;
    private BluetoothAdapter bluetoothAdapter;
    private Context context;
    private final long SCAN_PERIOD = 3000L;
    private Handler scanHandler;
    private final ScanCallback scanCallback = new ScanCallback(){

        public void onScanResult(int callbackType, final @NonNull ScanResult result) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    String deviceName = "";
                    if (ActivityCompat.checkSelfPermission((Context)BLEScanManager.this.context, (String)"android.permission.BLUETOOTH_CONNECT") != 0) {
                        // empty if block
                    }
                    if (result.getDevice().getName() != null) {
                        deviceName = result.getDevice().getName();
                    } else if (result.getScanRecord().getDeviceName() != null) {
                        deviceName = result.getScanRecord().getDeviceName();
                    } else {
                        return;
                    }
                    if (BLEScanManager.this.bleCallback != null) {
                        BLEScanManager.this.bleCallback.onBLEScanResult(result.getDevice(), deviceName, result.getRssi() + "");
                    }
                }
            }).start();
        }

        public void onScanFailed(int errorCode) {
            if (BLEScanManager.this.bleCallback != null) {
                switch (errorCode) {
                    case 1: {
                        BLEScanManager.this.bleCallback.onBLEScanError("Scan failed : device already started");
                        break;
                    }
                    case 2: {
                        BLEScanManager.this.bleCallback.onBLEScanError("Scan failed : application registration failed");
                        break;
                    }
                    case 3: {
                        BLEScanManager.this.bleCallback.onBLEScanError("Scan failed : internal error");
                        break;
                    }
                    case 4: {
                        BLEScanManager.this.bleCallback.onBLEScanError("Scan failed : feature unsupported");
                        break;
                    }
                    case 5: {
                        BLEScanManager.this.bleCallback.onBLEScanError("Scan failed : out of hardware resources");
                        break;
                    }
                    case 6: {
                        BLEScanManager.this.bleCallback.onBLEScanError("Scan failed : scanning too frequently");
                        break;
                    }
                    default: {
                        BLEScanManager.this.bleCallback.onBLEScanError("scan failed : error undefined");
                    }
                }
            }
        }
    };

    private BLEScanManager() {
    }

    public static BLEScanManager getInstance(Context context) {
        if (instance == null) {
            instance = new BLEScanManager();
            BluetoothManager bluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
            BLEScanManager.instance.bluetoothAdapter = bluetoothManager.getAdapter();
            BLEScanManager.instance.context = context;
        }
        return instance;
    }

    public void setBLEScanCallback(BLEScanCallback bleManagerCallback) {
        this.bleCallback = bleManagerCallback;
    }

    public void startScan() {
        this.startScanDevice();
    }

    public void stopScan() {
        this.stopScanDevice();
    }

    private void startScanDevice() {
        ScanSettings settings = new ScanSettings.Builder().setScanMode(2).setUseHardwareBatchingIfSupported(false).build();
        BluetoothLeScannerCompat scanner = BluetoothLeScannerCompat.getScanner();
        try {
            scanner.startScan(null, settings, this.scanCallback);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.scanHandler == null) {
            this.scanHandler = new Handler();
        }
        this.scanHandler.removeCallbacksAndMessages(null);
        this.scanHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                BLEScanManager.this.stopScanDevice();
            }
        }, 3000L);
    }

    private void stopScanDevice() {
        if (this.bluetoothAdapter != null && this.bluetoothAdapter.isEnabled()) {
            BluetoothLeScannerCompat scanner = BluetoothLeScannerCompat.getScanner();
            scanner.stopScan(this.scanCallback);
            if (this.scanHandler != null) {
                this.scanHandler.removeCallbacksAndMessages(null);
            }
        }
    }
}

