/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a24d.communicationmanager;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import jp.co.asterisk.asreader.a24d.communicationmanager.CommunicationBarcodeCallback;
import jp.co.asterisk.asreader.a24d.communicationmanager.CommunicationDeviceCallback;
import jp.co.asterisk.asreader.a24d.communicationmanager.connection.ConnectionCallback;
import jp.co.asterisk.asreader.a24d.communicationmanager.connection.ConnectionType;
import jp.co.asterisk.asreader.a24d.communicationmanager.connection.ble.BLEScanCallback;
import jp.co.asterisk.asreader.a24d.communicationmanager.connection.usb.USBManager;
import jp.co.asterisk.asreader.a24d.communicationmanager.packet.AsReaderPacketConst;
import jp.co.asterisk.asreader.a24d.communicationmanager.packet.PacketModel;
import jp.co.asterisk.asreader.a24d.communicationmanager.packet.PacketParser;
import jp.co.asterisk.asreader.a24d.utility.LogLevel;
import jp.co.asterisk.asreader.a24d.utility.SDKLog;

public class CommunicationManager
implements ConnectionCallback {
    private static CommunicationManager instance;
    private final String TAG = "\u3010AsReaderSDK\u3011Comm";
    private final String TAG_TEST = "\u3010AsReaderSDKCommunicationTest\u3011" + CommunicationManager.class.getName();
    private CommunicationDeviceCallback deviceCallback;
    private CommunicationBarcodeCallback barcodeCallback;
    private ConnectionType connectionType;

    private CommunicationManager() {
    }

    public void setCommunicationDeviceCallback(CommunicationDeviceCallback deviceCallback) {
        this.deviceCallback = deviceCallback;
    }

    public void setCommunicationBarcodeCallback(CommunicationBarcodeCallback barcodeCallback) {
        this.barcodeCallback = barcodeCallback;
    }

    public static CommunicationManager getInstance() {
        if (instance == null) {
            instance = new CommunicationManager();
        }
        return instance;
    }

    public void initialize(Context context, ConnectionType connectionType) {
        switch (connectionType) {
            case USB: {
                USBManager.getInstance().initialize(context);
                USBManager.getInstance().setCallback(this);
            }
        }
        this.connectionType = connectionType;
        SDKLog.getInstance().Log("\u3010AsReaderSDK\u3011Comm", LogLevel.Information, "Communication manager initialized");
    }

    public boolean isOpen() {
        switch (this.connectionType) {
            case USB: {
                return USBManager.getInstance().isOpen();
            }
        }
        return false;
    }

    public void open() {
        SDKLog.getInstance().Log("\u3010AsReaderSDK\u3011Comm", LogLevel.Information, "CommunicationManager USB open");
        if (this.connectionType == ConnectionType.USB) {
            USBManager.getInstance().open();
        }
    }

    public void open(BluetoothDevice bluetoothDevice) {
        SDKLog.getInstance().Log("\u3010AsReaderSDK\u3011Comm", LogLevel.Information, "CommunicationManager BLE open");
    }

    public void close() {
        SDKLog.getInstance().Log("\u3010AsReaderSDK\u3011Comm", LogLevel.Information, "CommunicationManager close");
        switch (this.connectionType) {
            case USB: {
                USBManager.getInstance().close();
            }
        }
    }

    public boolean sendPacket(PacketModel packetModel) {
        packetModel.makeCRC();
        String logStr = "";
        for (byte buf : packetModel.toByteArray()) {
            logStr = logStr + String.format("%02X ", buf);
        }
        switch (this.connectionType) {
            case USB: {
                return USBManager.getInstance().sendData(packetModel.toByteArray());
            }
        }
        return false;
    }

    public boolean sendPacketNotCRC(PacketModel packetModel) {
        packetModel.makeCRC();
        String logStr = "";
        for (byte buf : packetModel.toByteArrayNotCRC()) {
            logStr = logStr + String.format("%02X ", buf);
        }
        switch (this.connectionType) {
            case USB: {
                return USBManager.getInstance().sendData(packetModel.toByteArrayNotCRC());
            }
        }
        return false;
    }

    public void executeTriggerAutoMode(boolean executeMode) {
        if (this.barcodeCallback != null) {
            this.barcodeCallback.onExecuteTriggerAutoMode(executeMode);
        }
    }

    public void connectedStatus(boolean status) {
        if (this.barcodeCallback != null) {
            this.barcodeCallback.onConnectedStatus(status);
        }
    }

    public void setBLEScanCallback(BLEScanCallback callback) {
    }

    public void startScanBLEDevices() {
    }

    public void stopScanBLEDevices() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReceivedData(byte[] data) {
        SDKLog.getInstance().Log("\u3010AsReaderSDK\u3011Comm", LogLevel.Debug, "CommunicationManager onReceivedData ");
        CommunicationManager communicationManager = this;
        synchronized (communicationManager) {
            PacketModel packetModel = PacketParser.getInstance().parse(data);
            if (packetModel == null) {
                return;
            }
            if (packetModel.getCommand() == -33) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            for (byte buf : data) {
                sb.append(String.format("%02X ", buf));
            }
            SDKLog.getInstance().Log("\u3010AsReaderSDK\u3011Comm", LogLevel.Information, "[RX Data] " + sb.toString());
            String bytesResult = String.format("%02X", packetModel.getCommand());
            String dataResult = SDKLog.getInstance().getHexString(data);
            AsReaderPacketConst.AsReaderPacket packetType = AsReaderPacketConst.getAsReaderPacket(packetModel.getCommand());
            SDKLog.getInstance().Log("\u3010AsReaderSDK\u3011Comm", LogLevel.Information, "Command : " + bytesResult + " Payload : " + packetModel.getPacketString() + " packetType = " + (Object)((Object)packetType));
            switch (packetType) {
                case CMD_SETTINGS_BARCODE_DATA_RESPONSE: 
                case CMD_SCAN_BARCODE_RESPONSE: 
                case CMD_GET_BARCODE_STOP_CONDITION: 
                case CMD_BARCODE_FACTORY_DEFAULT: 
                case CMD_BARCODE_ZEBRA_SETTING: 
                case CMD_STOP_AUTO_SCAN_BARCODE: {
                    SDKLog.getInstance().Log("\u3010AsReaderSDK\u3011Comm", LogLevel.Information, "To Barcode Callback (Normal)");
                    this.barcodeCallback.onReceivedData(packetModel, false);
                    break;
                }
                case CMD_BARCODE_BYPASS: 
                case CMD_SET_BARCODE_SSI_PARAMETER: 
                case CMD_GET_BARCODE_SSI_PARAMETER: {
                    SDKLog.getInstance().Log("\u3010AsReaderSDK\u3011Comm", LogLevel.Information, "To Barcode Callback (SSI)");
                    this.barcodeCallback.onReceivedData(packetModel, true);
                    break;
                }
                case CMD_HID_MODE: 
                case CMD_GET_MODULE_SLEEP_SETTING: {
                    this.deviceCallback.onReceivedData(packetModel);
                    break;
                }
                case CMD_SET_MODULE_SLEEP_SETTING: {
                    if (packetModel.getPayload()[0] != 0 || packetModel.getPayload()[1] != 1) break;
                    SDKLog.getInstance().Log(this.TAG_TEST, LogLevel.Information, "[GET]SleepTime " + (Object)((Object)packetType));
                    this.deviceCallback.onReceivedData(packetModel);
                    break;
                }
                case CMD_BATTERY_STATUS: 
                case CMD_TRIGGER_EVENT: 
                case CMD_SET_DEVICE_SETTINGS: 
                case CMD_GET_DEVICE_SETTINGS: 
                case CMD_GET_READER_INFO: 
                case CMD_CTL_POWER_RESET: 
                case CMD_SET_CHARGE_CONTROL: {
                    SDKLog.getInstance().Log("\u3010AsReaderSDK\u3011Comm", LogLevel.Information, "To Device Callback");
                    this.deviceCallback.onReceivedData(packetModel);
                    break;
                }
                case CMD_FAILED: {
                    if (packetModel.getPayload().length > 1 && (packetModel.getPayload()[1] == -70 || packetModel.getPayload()[1] == 1)) {
                        this.deviceCallback.onReceivedData(packetModel);
                        return;
                    }
                    this.deviceCallback.onReceivedData(packetModel);
                    this.barcodeCallback.onReceivedData(packetModel, false);
                    break;
                }
                case UNKNOWN: {
                    break;
                }
                default: {
                    SDKLog.getInstance().Log("\u3010AsReaderSDK\u3011Comm", LogLevel.Information, "Data : " + dataResult + "  Command : 0x" + bytesResult);
                }
            }
        }
    }

    @Override
    public void onReceivedBleConnection(boolean connected) {
    }
}

