/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a24d.sdk;

import android.content.ComponentName;
import android.content.Context;
import android.util.Log;
import jp.co.asterisk.asreader.a24d.communicationmanager.CommunicationManager;
import jp.co.asterisk.asreader.a24d.communicationmanager.connection.ConnectionType;
import jp.co.asterisk.asreader.a24d.communicationmanager.connection.ble.BLEScanCallback;
import jp.co.asterisk.asreader.a24d.utility.LogLevel;
import jp.co.asterisk.asreader.a24d.utility.SDKLog;
import jp.co.asterisk.asreader.a24d.utility.SDKSharedData;
import jp.co.asterisk.asreader.barcodemanager.BarcodeManager;
import jp.co.asterisk.asreader.devicemanager.DeviceManager;

public class AsReader {
    private static AsReader instance;
    private final String TAG = "\u3010AsReaderSDK\u3011" + AsReader.class.getSimpleName();
    private static final String VERSION_NAME = "4.5.6";
    private Context mContext = null;

    private AsReader() {
    }

    public static AsReader getInstance() {
        if (instance == null) {
            instance = new AsReader();
        }
        return instance;
    }

    public DeviceManager getDeviceManager() {
        return DeviceManager.getInstance();
    }

    public BarcodeManager getBarcodeManager() {
        return BarcodeManager.getInstance();
    }

    public String getVersion() {
        return VERSION_NAME;
    }

    public void initialize(Context context, ConnectionType connectionType) {
        this.mContext = context;
        SDKLog.getInstance().initialize(context);
        String dataKey = context.getPackageName() + ".A24D_SDK_DATA";
        SDKSharedData.getInstance().initialize(dataKey, context);
        CommunicationManager.getInstance().initialize(context, connectionType);
        DeviceManager.getInstance().initialize(context, connectionType);
        BarcodeManager.getInstance().initialize(context);
    }

    public void setLogLevel(LogLevel level) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "API:setLogLevel ");
        SDKLog.getInstance().setLogLevel(level);
    }

    public LogLevel getLogLevel() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "API:getLogLevel ");
        return SDKLog.getInstance().getLogLevel();
    }

    public void setLog(boolean enable) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "API:setLog ");
        SDKLog.getInstance().setLogEnable(enable);
    }

    public void removeSDKLog() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "API:removeSDKLog ");
        SDKLog.getInstance().removeAllLog();
    }

    public void setBLEScanCallback(BLEScanCallback callback) {
        CommunicationManager.getInstance().setBLEScanCallback(callback);
    }

    public void startScanBleDevice() {
        CommunicationManager.getInstance().startScanBLEDevices();
    }

    public void stopScanBleDevice() {
        CommunicationManager.getInstance().stopScanBLEDevices();
    }

    public void enableAutoLaunchApp(boolean enable, String aliasName) {
        if (this.mContext == null) {
            return;
        }
        String packageName = this.mContext.getPackageName();
        int newState = enable ? 1 : 2;
        Log.d((String)this.TAG, (String)"----- enableAutoLaunchApp -----");
        Log.d((String)this.TAG, (String)("Enable = " + (enable ? "True" : "False")));
        Log.d((String)this.TAG, (String)packageName);
        this.mContext.getPackageManager().setComponentEnabledSetting(new ComponentName(packageName, packageName + "." + aliasName), newState, 1);
    }
}

