/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.barcodemanager.parse;

import android.util.Log;
import java.util.ArrayList;
import jp.co.asterisk.asreader.a24d.communicationmanager.packet.AsReaderPacketConst;
import jp.co.asterisk.asreader.a24d.communicationmanager.packet.PacketModel;
import jp.co.asterisk.asreader.a24d.utility.LogLevel;
import jp.co.asterisk.asreader.a24d.utility.SDKLog;
import jp.co.asterisk.asreader.barcodemanager.SymbologyInfoModel;
import jp.co.asterisk.asreader.barcodemanager.define.BarcodeConst;
import jp.co.asterisk.asreader.barcodemanager.define.BarcodeManagerError;
import jp.co.asterisk.asreader.barcodemanager.define.BarcodeResult;
import jp.co.asterisk.asreader.barcodemanager.define.SSICommandModel;
import jp.co.asterisk.asreader.barcodemanager.define.SecurityLevels;
import jp.co.asterisk.asreader.barcodemanager.model.OCRInfoModel;
import jp.co.asterisk.asreader.barcodemanager.model.SecurityInfoModel;
import jp.co.asterisk.asreader.barcodemanager.parse.BarcodePacketParserCallback;

public class BarcodePacketParser {
    private static final String TAG = "\u3010AsReaderSDK\u3011" + BarcodePacketParser.class.getSimpleName();
    private static final String TAG_TEST = "\u3010AsReaderSDKBarcodePacketParserTEST\u3011" + BarcodePacketParser.class.getSimpleName();
    private static final String TAG_SYMBOLDATA_TEST = "\u3010AsReaderSDKBarcodePacketParserSymbolTEST\u3011" + BarcodePacketParser.class.getSimpleName();
    private final int RECEIVED_FINISH = -128;
    private static BarcodePacketParser instance;
    private BarcodePacketParserCallback mCallback = null;
    private ArrayList<SymbologyInfoModel> mSymbologyInfoArray = new ArrayList();
    private ArrayList<OCRInfoModel> mOCRInfoArray = new ArrayList();
    private ArrayList<SecurityInfoModel> mSecurityInfoArray = new ArrayList();
    private ArrayList<Byte> barcodeData = new ArrayList();

    private BarcodePacketParser() {
    }

    public static BarcodePacketParser getInstance() {
        if (instance == null) {
            instance = new BarcodePacketParser();
        }
        return instance;
    }

    public void setCallback(BarcodePacketParserCallback callback) {
        this.mCallback = callback;
    }

    public void setSymbologyInfoArray(ArrayList<SymbologyInfoModel> arrayList) {
        this.mSymbologyInfoArray = arrayList;
    }

    public void setOCRInfoArray(ArrayList<OCRInfoModel> arrayList) {
        this.mOCRInfoArray = arrayList;
    }

    public void setSecurityInfoArray(ArrayList<SecurityInfoModel> arrayList) {
        this.mSecurityInfoArray = arrayList;
    }

    public ArrayList<SymbologyInfoModel> getSymbologyInfoArray() {
        return this.mSymbologyInfoArray;
    }

    public void parsePacket(PacketModel packetModel) {
        String commandStr = String.format("%02X", packetModel.getCommand());
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "onReceivedData : " + commandStr);
        byte[] payload = packetModel.getPayload();
        AsReaderPacketConst.AsReaderPacket packet = AsReaderPacketConst.getAsReaderPacket((byte)packetModel.getCommand());
        switch (packet) {
            case CMD_BARCODE_ZEBRA_SETTING: {
                SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "CMD_BARCODE_ZEBRA_SETTING");
                break;
            }
            case CMD_SCAN_BARCODE_RESPONSE: {
                for (int i = 1; i < payload.length; ++i) {
                    this.barcodeData.add((byte)(payload[i] & 0xFF));
                }
                SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "Payload = " + this.convertStringFromByteArray(payload));
                byte checkBuf = (byte)(payload[0] & 0xFF);
                if (checkBuf != -128) break;
                byte[] receiveData = new byte[this.barcodeData.size()];
                for (int i = 0; i < this.barcodeData.size(); ++i) {
                    receiveData[i] = this.barcodeData.get(i);
                }
                if (this.mCallback != null) {
                    this.mCallback.onParsedBarcodeDecodeData(receiveData);
                }
                this.barcodeData.clear();
                break;
            }
            case CMD_BARCODE_FACTORY_DEFAULT: {
                this.mCallback.onParsedBarcodeResponse(BarcodeConst.BarcodeCommandAction.FACTORY_DEFAULT, this.parseFactoryDefault(payload));
                break;
            }
            case CMD_GET_BARCODE_STOP_CONDITION: {
                this.mCallback.onParsedBarcodeResponse(BarcodeConst.BarcodeCommandAction.GET_INFO_STOP_CONDITION, this.parseStopCondition(payload));
                break;
            }
            case CMD_FAILED: {
                if (payload[1] == 54 && payload[2] == 10) {
                    this.mCallback.onParsedBarcodeError(BarcodeManagerError.COMMAND_ERROR_START_DECODE_FAILED);
                    break;
                }
                if (payload[1] != AsReaderPacketConst.AsReaderPacket.CMD_SET_BARCODE_SSI_PARAMETER.getByte()) break;
                this.mCallback.onParsedBarcodeError(BarcodeManagerError.SETTINGS_ERROR_SETTINGS_FAILED);
            }
        }
    }

    public void parseSSIPacket(PacketModel packetModel, PacketModel sendPacket, BarcodeConst.BarcodeCommandAction action) {
        String commandStr = String.format("%02X", packetModel.getCommand());
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "parseSSIPacket onReceivedData : " + commandStr);
        byte[] payload = packetModel.getPayload();
        AsReaderPacketConst.AsReaderPacket packet = AsReaderPacketConst.getAsReaderPacket((byte)packetModel.getCommand());
        if (packetModel.getCommand() == 114) {
            // empty if block
        }
        switch (packet) {
            case CMD_BARCODE_BYPASS: {
                if (this.mCallback == null) break;
                this.mCallback.onBypass(action, sendPacket.getPayload());
                break;
            }
            case CMD_GET_BARCODE_SSI_PARAMETER: {
                if (action == BarcodeConst.BarcodeCommandAction.GET_INFO_SYSTEM_BEEP) {
                    this.mCallback.onParsedBarcodeResponse(action, this.parseGetSystemBeep(payload));
                    break;
                }
                if (action == BarcodeConst.BarcodeCommandAction.GET_INFO_SYMBOLOGIES_ENABLE_STATUS) {
                    this.mCallback.onParsedBarcodeResponse(action, this.parseGetSymbologies(payload));
                    break;
                }
                if (action == BarcodeConst.BarcodeCommandAction.GET_INFO_OCR_ENABLE_STATUS) {
                    this.mCallback.onParsedBarcodeResponse(action, this.parseGetOCR(payload));
                    break;
                }
                if (action == BarcodeConst.BarcodeCommandAction.GET_INFO_SECURITY_LEVEL_ENABLE_STATUS) {
                    this.mCallback.onParsedBarcodeResponse(action, this.parseGetSecurityLevel(payload));
                    break;
                }
                if (action == BarcodeConst.BarcodeCommandAction.GET_INFO_CHARACTER_STATUS) {
                    this.mCallback.onParsedBarcodeResponse(action, this.parseCharacter(payload[1]));
                    break;
                }
                if (action == BarcodeConst.BarcodeCommandAction.GET_INFO_SCAN_DATA_TRANSMISSION_FORMAT) {
                    this.mCallback.onParsedBarcodeResponse(action, this.parseScanDataTransmissionFormat(payload[1]));
                    break;
                }
                if (action == BarcodeConst.BarcodeCommandAction.GET_INFO_CODE_ID_ENABLE) {
                    this.mCallback.onParsedBarcodeResponse(action, this.parseCharacter(payload[1]));
                    break;
                }
                if (action == BarcodeConst.BarcodeCommandAction.GET_INFO_NOTIS_EDITING) {
                    this.mCallback.onParsedBarcodeResponse(action, this.parseGetNotisEditing(payload));
                    break;
                }
                if (action != BarcodeConst.BarcodeCommandAction.GET_INFO_PRESENTATION_MODE) break;
                this.mCallback.onParsedBarcodeResponse(action, this.parseGetTriggerMode(payload));
                break;
            }
            case CMD_SET_BARCODE_SSI_PARAMETER: {
                SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "RCP_CMD_SET_SSI_PARAM : " + (Object)((Object)SSICommandModel.SSICommand.getEnum(payload[0])) + " pay = " + String.format("%02X", payload[0]));
                SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "Receive Payload = " + this.convertStringFromByteArray(payload));
                if (sendPacket != null) {
                    SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "Send Payload = " + this.convertStringFromByteArray(sendPacket.getPayload()));
                } else {
                    SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "Send Payload = null");
                }
                SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "Action = " + (Object)((Object)action));
                switch (action) {
                    case SETTINGS_SYSTEM_BEEP: {
                        this.mCallback.onParsedBarcodeResponse(BarcodeConst.BarcodeCommandAction.SETTINGS_SYSTEM_BEEP, this.parseSetSystemBeep(payload, sendPacket.getPayload()));
                        break;
                    }
                    case SETTINGS_CHARACTER_STATUS: {
                        this.mCallback.onParsedBarcodeResponse(BarcodeConst.BarcodeCommandAction.SETTINGS_CHARACTER_STATUS, this.parseSetCharacter(sendPacket.getPayload()));
                        break;
                    }
                    case SETTINGS_SYMBOLOGIES: {
                        SDKLog.getInstance().Log(TAG_SYMBOLDATA_TEST, LogLevel.Information, "RCP_CMD_SET_SSI_PARAM : " + (Object)((Object)SSICommandModel.SSICommand.getEnum(payload[0])) + " pay = " + String.format("%02X", payload[0]));
                        SDKLog.getInstance().Log(TAG_SYMBOLDATA_TEST, LogLevel.Information, "Payload = " + this.convertStringFromByteArray(payload));
                        if (SSICommandModel.SSICommand.getEnum(payload[0]) == SSICommandModel.SSICommand.SCAN_DATA_TRANSMISSION_FORMAT) {
                            this.mCallback.onParsedBarcodeResponse(BarcodeConst.BarcodeCommandAction.GET_INFO_SCAN_DATA_TRANSMISSION_FORMAT, this.parseScanDataTransmissionFormat(payload[0]));
                            break;
                        }
                        SDKLog.getInstance().Log(TAG_SYMBOLDATA_TEST, LogLevel.Information, "parseSetSymbologies");
                        this.mCallback.onParsedBarcodeResponse(BarcodeConst.BarcodeCommandAction.SETTINGS_SYMBOLOGIES, this.parseSetSymbologies(payload, sendPacket.getPayload()));
                        break;
                    }
                    case SETTING_OCR: {
                        SDKLog.getInstance().Log(TAG_SYMBOLDATA_TEST, LogLevel.Information, "SETTING OCR");
                        this.mCallback.onParsedBarcodeResponse(BarcodeConst.BarcodeCommandAction.SETTING_OCR, this.parseSetOCR(payload, sendPacket.getPayload()));
                        break;
                    }
                    case SETTING_SECURITY_LEVEL: {
                        this.mCallback.onParsedBarcodeResponse(BarcodeConst.BarcodeCommandAction.SETTING_SECURITY_LEVEL, this.parseSetSecurityLevel(payload, sendPacket.getPayload()));
                    }
                    case SETTINGS_NOTIS_EDITING: {
                        this.mCallback.onParsedBarcodeResponse(BarcodeConst.BarcodeCommandAction.SETTINGS_NOTIS_EDITING, this.parseSetNotisEditing(sendPacket.getPayload()));
                        break;
                    }
                    case SETTINGS_PRESENTATION_MODE: {
                        this.mCallback.onParsedBarcodeResponse(BarcodeConst.BarcodeCommandAction.SETTINGS_PRESENTATION_MODE, this.parseSetTriggerMode(payload));
                    }
                }
                break;
            }
            case CMD_GET_MODULE_SLEEP_SETTING: {
                BarcodeResult.Result result = payload[0] == 0 ? BarcodeResult.Result.PRESENTATION_GET_DISABLED : BarcodeResult.Result.PRESENTATION_GET_ENABLED;
                BarcodeResult barcodeResult = new BarcodeResult(BarcodeResult.Status.SUCCESS, result, "", null);
                this.mCallback.onParsedBarcodeResponse(BarcodeConst.BarcodeCommandAction.GET_INFO_PRESENTATION_MODE, barcodeResult);
                break;
            }
            case CMD_FAILED: {
                if (payload[1] == 54 && payload[2] == 10) {
                    this.mCallback.onParsedBarcodeError(BarcodeManagerError.COMMAND_ERROR_START_DECODE_FAILED);
                    break;
                }
                if (payload[1] != AsReaderPacketConst.AsReaderPacket.CMD_SET_BARCODE_SSI_PARAMETER.getByte()) break;
                this.mCallback.onParsedBarcodeError(BarcodeManagerError.SETTINGS_ERROR_SETTINGS_FAILED);
            }
        }
    }

    private String convertStringFromByteArray(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (byte byteBuf : bytes) {
            buf.append(String.format("%02X ", byteBuf));
        }
        return buf.toString();
    }

    private BarcodeResult parseSetCharacter(byte[] payload) {
        String message = "";
        BarcodeResult.Status status = BarcodeResult.Status.SUCCESS;
        BarcodeResult.Result result = BarcodeResult.Result.UNKNOWN;
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "parseSetCharacter payload = " + SDKLog.toStringFromByte((byte[])payload) + " Length = " + payload.length);
        switch (SSICommandModel.CodeID.getEnum(payload[3])) {
            case NONE: {
                message = "Success SET Character NONE.";
                result = BarcodeResult.Result.CHARACTER_NONE;
                break;
            }
            case AIM: {
                message = "Success SET Character AIM.";
                result = BarcodeResult.Result.CHARACTER_AIM;
                break;
            }
            case SYMBOL: {
                message = "Success SET Character SYMBOL.";
                result = BarcodeResult.Result.CHARACTER_SYMBOL;
                break;
            }
            default: {
                message = "Failed SET SSI command.";
                status = BarcodeResult.Status.FAILED;
            }
        }
        return new BarcodeResult(status, result, message, null);
    }

    private BarcodeResult parseCharacter(byte buf) {
        String message = "";
        BarcodeResult.Status status = BarcodeResult.Status.SUCCESS;
        BarcodeResult.Result result = BarcodeResult.Result.UNKNOWN;
        switch (SSICommandModel.CodeID.getEnum(buf)) {
            case NONE: {
                message = "Success get Character NONE.";
                result = BarcodeResult.Result.CHARACTER_NONE;
                break;
            }
            case AIM: {
                message = "Success get Character AIM.";
                result = BarcodeResult.Result.CHARACTER_AIM;
                break;
            }
            case SYMBOL: {
                message = "Success get Character SYMBOL.";
                result = BarcodeResult.Result.CHARACTER_SYMBOL;
                break;
            }
            default: {
                message = "Failed get SSI command.";
                status = BarcodeResult.Status.FAILED;
            }
        }
        return new BarcodeResult(status, result, message, null);
    }

    private BarcodeResult parseScanDataTransmissionFormat(byte buf) {
        BarcodeResult result = new BarcodeResult(BarcodeResult.Status.SUCCESS, BarcodeResult.Result.UNKNOWN, "", null);
        SSICommandModel.TransmissionFormat format = SSICommandModel.TransmissionFormat.getEnum(buf);
        switch (format) {
            case DATA_AS_IS: {
                result.setResult(BarcodeResult.Result.FORMAT_DATA_ONLY);
                break;
            }
            case DATA_SUFFIX1: {
                result.setResult(BarcodeResult.Result.FORMAT_DATA_SUFFIX_TYPE1);
                break;
            }
            case DATA_SUFFIX2: {
                result.setResult(BarcodeResult.Result.FORMAT_DATA_SUFFIX_TYPE2);
                break;
            }
            case DATA_SUFFIX1_SUFFIX2: {
                result.setResult(BarcodeResult.Result.FORMAT_DATA_SUFFIX_TYPE3);
                break;
            }
            case PREFIX_DATA: {
                result.setResult(BarcodeResult.Result.FORMAT_PREFIX_DATA);
                break;
            }
            case PREFIX_DATA_SUFFIX1: {
                result.setResult(BarcodeResult.Result.FORMAT_PREFIX_DATA_SUFFIX_TYPE1);
                break;
            }
            case PREFIX_DATA_SUFFIX2: {
                result.setResult(BarcodeResult.Result.FORMAT_PREFIX_DATA_SUFFIX_TYPE2);
                break;
            }
            case PREFIX_DATA_SUFFIX1_SUFFIX2: {
                result.setResult(BarcodeResult.Result.FORMAT_PREFIX_DATA_SUFFIX_TYPE3);
                break;
            }
            default: {
                result.setStatus(BarcodeResult.Status.FAILED);
                result.setResult(BarcodeResult.Result.UNKNOWN);
            }
        }
        result.setMessage("Get Scan Data Format type. \n(" + result.getResult().getString() + ")");
        return result;
    }

    private BarcodeResult parseSetSymbologies(byte[] receivePayload, byte[] sendPayload) {
        BarcodeResult result = new BarcodeResult(BarcodeResult.Status.SUCCESS, BarcodeResult.Result.SYMBOLOGY_STATUS_SET, "", null);
        result.setSymbologyInfoArray(this.mSymbologyInfoArray);
        return result;
    }

    private BarcodeResult parseSetOCR(byte[] receivePayload, byte[] sendPayload) {
        BarcodeResult result = new BarcodeResult(BarcodeResult.Status.SUCCESS, BarcodeResult.Result.OCR_STATUS_SET, "", null);
        result.setOCRInfoArray(this.mOCRInfoArray);
        return result;
    }

    private BarcodeResult parseSetSecurityLevel(byte[] receivePayload, byte[] sendPayload) {
        BarcodeResult result = new BarcodeResult(BarcodeResult.Status.SUCCESS, BarcodeResult.Result.SECURITY_LEVEL_STATUS_SET, "", null);
        result.setSecurityInfoArray(this.mSecurityInfoArray);
        return result;
    }

    private BarcodeResult parseGetSymbologies(byte[] payload) {
        BarcodeResult result = new BarcodeResult(BarcodeResult.Status.FAILED, BarcodeResult.Result.SYMBOLOGY_STATUS_GET, "", null);
        int byteIndex = 0;
        if (payload == null || payload.length <= 0) {
            return result;
        }
        result.setStatus(BarcodeResult.Status.SUCCESS);
        result.setResult(BarcodeResult.Result.SYMBOLOGY_STATUS_GET);
        ArrayList<SymbologyInfoModel> resultList = new ArrayList<SymbologyInfoModel>();
        for (SymbologyInfoModel model : this.mSymbologyInfoArray) {
            byte[] commandBufBytes;
            StringBuilder commandBuf = new StringBuilder();
            for (byte buf : commandBufBytes = model.symbology.getHexCommand()) {
                commandBuf.append(String.format("%02X ", buf));
            }
            Log.d((String)TAG_TEST, (String)("\u3010Response\u3011getSymbologySettings : " + (Object)((Object)model.symbology) + " Command = " + commandBuf));
            if (model.symbology == null) continue;
            boolean isEnable = false;
            int length = model.symbology.getHexCommand().length;
            Log.d((String)TAG_TEST, (String)("payload Length : " + payload.length + " byteIndex : " + byteIndex + " length = " + length));
            byte statusByte = payload[byteIndex + length];
            if (statusByte == 1) {
                isEnable = true;
            }
            SymbologyInfoModel addInfoModel = new SymbologyInfoModel(model.symbology, isEnable);
            resultList.add(addInfoModel);
            byteIndex = byteIndex + model.symbology.getHexCommand().length + 1;
        }
        result.setSymbologyInfoArray(resultList);
        return result;
    }

    private BarcodeResult parseGetOCR(byte[] payload) {
        BarcodeResult result = new BarcodeResult(BarcodeResult.Status.FAILED, BarcodeResult.Result.OCR_STATUS_GET, "", null);
        int byteIndex = 0;
        if (payload == null || payload.length <= 0) {
            return result;
        }
        result.setStatus(BarcodeResult.Status.SUCCESS);
        result.setResult(BarcodeResult.Result.OCR_STATUS_GET);
        ArrayList<OCRInfoModel> resultList = new ArrayList<OCRInfoModel>();
        for (OCRInfoModel model : this.mOCRInfoArray) {
            byte[] commandBufBytes;
            StringBuilder commandBuf = new StringBuilder();
            for (byte buf : commandBufBytes = model.ocr.getHexCommand()) {
                commandBuf.append(String.format("%02X ", buf));
            }
            Log.d((String)TAG_TEST, (String)("\u3010Response\u3011getSymbologySettings : " + (Object)((Object)model.ocr) + " Command = " + commandBuf));
            if (model.ocr == null) continue;
            boolean isEnable = false;
            int length = model.ocr.getHexCommand().length;
            Log.d((String)TAG_TEST, (String)("payload Length : " + payload.length + " byteIndex : " + byteIndex + " length = " + length));
            byte statusByte = payload[byteIndex + length];
            if (statusByte == 1) {
                isEnable = true;
            }
            OCRInfoModel addInfoModel = new OCRInfoModel(model.ocr, isEnable);
            resultList.add(addInfoModel);
            byteIndex = byteIndex + model.ocr.getHexCommand().length + 1;
        }
        result.setOCRInfoArray(resultList);
        return result;
    }

    private BarcodeResult parseGetSecurityLevel(byte[] payload) {
        BarcodeResult result = new BarcodeResult(BarcodeResult.Status.FAILED, BarcodeResult.Result.SECURITY_LEVEL_STATUS_GET, "", null);
        int byteIndex = 0;
        if (payload == null || payload.length <= 0) {
            return result;
        }
        result.setStatus(BarcodeResult.Status.SUCCESS);
        ArrayList<SecurityInfoModel> resultList = new ArrayList<SecurityInfoModel>();
        for (SecurityInfoModel model : this.mSecurityInfoArray) {
            byte[] commandBufBytes;
            StringBuilder commandBuf = new StringBuilder();
            for (byte buf : commandBufBytes = model.securityLevelType.getHexCommand()) {
                commandBuf.append(String.format("%02X ", buf));
            }
            Log.d((String)TAG_TEST, (String)("\u3010Response\u3011getSecurityLevelSettings : " + (Object)((Object)model.securityLevelType) + " Command = " + commandBuf));
            if (model.securityLevelType == null) continue;
            SecurityLevels.SecurityLevel level = SecurityLevels.SecurityLevel.LEVEL_1;
            int length = model.securityLevelType.getHexCommand().length;
            Log.d((String)TAG_TEST, (String)("payload Length : " + payload.length + " byteIndex : " + byteIndex + " length = " + length));
            byte statusByte = payload[byteIndex + length];
            for (SecurityLevels.SecurityLevel levels : SecurityLevels.SecurityLevel.values()) {
                if (statusByte != levels.getNum()) continue;
                level = levels;
            }
            SecurityInfoModel addInfoModel = new SecurityInfoModel(model.securityLevelType, level);
            resultList.add(addInfoModel);
            byteIndex = byteIndex + model.securityLevelType.getHexCommand().length + 1;
        }
        result.setSecurityInfoArray(resultList);
        return result;
    }

    private BarcodeResult parseStopCondition(byte[] payload) {
        BarcodeResult result = new BarcodeResult(BarcodeResult.Status.SUCCESS, BarcodeResult.Result.UNKNOWN, "Unknown", null);
        if (payload == null) {
            result.setMessage("Success set stop conditions.");
            result.setResult(BarcodeResult.Result.STOP_CONDITIONS_CONTINUOUS_ON);
        } else if (payload[1] == -1) {
            result.setMessage("Continuous Scan On.");
            result.setResult(BarcodeResult.Result.STOP_CONDITIONS_CONTINUOUS_ON);
        } else if (payload[1] == 0 || payload[1] == 1) {
            result.setMessage("Continuous Scan Off.");
            result.setResult(BarcodeResult.Result.STOP_CONDITIONS_CONTINUOUS_OFF);
        }
        return result;
    }

    private BarcodeResult parseFactoryDefault(byte[] payload) {
        return new BarcodeResult(BarcodeResult.Status.SUCCESS, BarcodeResult.Result.FACTORY_DEFAULT, "Success Factory default.", null);
    }

    private BarcodeResult parseGetSystemBeep(byte[] receivedPayload) {
        BarcodeResult result = new BarcodeResult(BarcodeResult.Status.FAILED, BarcodeResult.Result.UNKNOWN, "System beep GET receive response is UNKNOWN.", null);
        if (receivedPayload == null) {
            return result;
        }
        if (receivedPayload[0] != 0 || receivedPayload == null) {
            result.setStatus(BarcodeResult.Status.FAILED);
            result.setMessage("System beep GET Failed.");
        } else {
            result.setStatus(BarcodeResult.Status.SUCCESS);
            if (receivedPayload[2] == SSICommandModel.SystemBeep.NONE.getCommand()) {
                result.setMessage("System beep GET sound status OFF.");
                result.setResult(BarcodeResult.Result.SYSTEM_BEEP_SOUND_NONE);
            } else {
                result.setMessage("System beep GET sound status ON.");
                SSICommandModel.SystemBeep systemBeep = SSICommandModel.SystemBeep.getEnum(receivedPayload[1]);
                result.setResult(SSICommandModel.SystemBeep.getResultObject(systemBeep));
            }
        }
        return result;
    }

    private BarcodeResult parseSetSystemBeep(byte[] receivedPayload, byte[] sendPayload) {
        BarcodeResult result = new BarcodeResult(BarcodeResult.Status.FAILED, BarcodeResult.Result.UNKNOWN, "Unknown", null);
        if (receivedPayload == null) {
            result.setMessage("System beep SET receive response is UNKNOWN.");
        } else if (receivedPayload[0] != 0 || receivedPayload == null) {
            result.setMessage("System beep SET Failed.");
        } else {
            result.setStatus(BarcodeResult.Status.SUCCESS);
            if (sendPayload[2] == SSICommandModel.SystemBeep.NONE.getCommand()) {
                result.setMessage("System beep SET sound status OFF.");
                result.setResult(BarcodeResult.Result.SYSTEM_BEEP_SOUND_NONE);
            } else {
                result.setMessage("System beep SET sound status ON.");
                SSICommandModel.SystemBeep systemBeep = SSICommandModel.SystemBeep.getEnum(sendPayload[1]);
                result.setResult(SSICommandModel.SystemBeep.getResultObject(systemBeep));
            }
        }
        return result;
    }

    private BarcodeResult parseSetNotisEditing(byte[] receivedPayload) {
        BarcodeResult result = new BarcodeResult(BarcodeResult.Status.FAILED, BarcodeResult.Result.UNKNOWN, "NOTIS ediitng SET response is UNKNOWN.", null);
        if (receivedPayload == null) {
            return result;
        }
        if (receivedPayload[2] != SSICommandModel.SSICommand.NOTIS_EDITING.getCommand() || receivedPayload.length < 4) {
            result.setMessage("NOTIS editing SET is Failed.");
        } else {
            result.setStatus(BarcodeResult.Status.SUCCESS);
            if (receivedPayload[3] == SSICommandModel.SSIParameter.RESPONSE_DISABLE.getCommand()) {
                result.setMessage("NOTIS ediitng SET is OFF.");
                result.setResult(BarcodeResult.Result.NOTIS_EDITING_GET_DISABLED);
            }
            if (receivedPayload[3] == SSICommandModel.SSIParameter.RESPONSE_ENABLE.getCommand()) {
                result.setMessage("NOTIS ediitng SET is ON.");
                result.setResult(BarcodeResult.Result.NOTIS_EDITING_GET_ENABLED);
            }
        }
        return result;
    }

    private BarcodeResult parseGetNotisEditing(byte[] receivedPayload) {
        BarcodeResult result = new BarcodeResult(BarcodeResult.Status.FAILED, BarcodeResult.Result.UNKNOWN, "NOTIS ediitng GET response is UNKNOWN.", null);
        if (receivedPayload == null) {
            return result;
        }
        if (receivedPayload[0] != SSICommandModel.SSICommand.NOTIS_EDITING.getCommand() || receivedPayload.length < 2) {
            result.setStatus(BarcodeResult.Status.FAILED);
            result.setMessage("NOTIS ediitng GET Failed.");
        } else {
            result.setStatus(BarcodeResult.Status.SUCCESS);
            if (receivedPayload[1] == SSICommandModel.SSIParameter.RESPONSE_DISABLE.getCommand()) {
                result.setMessage("NOTIS ediitng GET is OFF.");
                result.setResult(BarcodeResult.Result.NOTIS_EDITING_GET_DISABLED);
            } else {
                result.setMessage("NOTIS ediitng GET is ON.");
                result.setResult(BarcodeResult.Result.NOTIS_EDITING_GET_ENABLED);
            }
        }
        return result;
    }

    private BarcodeResult parseSetTriggerMode(byte[] receivedPayload) {
        BarcodeResult result = new BarcodeResult(BarcodeResult.Status.FAILED, BarcodeResult.Result.PRESENTATION_SET, "TRIGGER MODE SET response is UNKNOWN.", null);
        if (receivedPayload[0] == 0) {
            result.setStatus(BarcodeResult.Status.SUCCESS);
            result.setResult(BarcodeResult.Result.PRESENTATION_SET);
            result.setMessage("TRIGGER MODE SET response is SUCCESS");
        }
        return result;
    }

    private BarcodeResult parseGetTriggerMode(byte[] receivedPayload) {
        BarcodeResult result = new BarcodeResult(BarcodeResult.Status.FAILED, BarcodeResult.Result.UNKNOWN, "TRIGGER MODE GET response is UNKNOWN.", null);
        if (receivedPayload == null) {
            return result;
        }
        if (receivedPayload[0] != SSICommandModel.SSICommand.PRESENTATION_TRIGGER_MODE.getCommand() || receivedPayload.length < 2) {
            result.setStatus(BarcodeResult.Status.FAILED);
            result.setMessage("TRIGGER MODE GET Failed.");
        } else {
            result.setStatus(BarcodeResult.Status.SUCCESS);
            if (receivedPayload[1] == SSICommandModel.PresentationMode.PRESENTATION.getCommand()) {
                result.setMessage("TRIGGER MODE GET is PRESENTATION");
                result.setResult(BarcodeResult.Result.PRESENTATION_GET_ENABLED);
            } else if (receivedPayload[1] == SSICommandModel.PresentationMode.STANDARD.getCommand()) {
                result.setMessage("TRIGGER MODE GET is STANDARD");
                result.setResult(BarcodeResult.Result.PRESENTATION_GET_DISABLED);
            } else {
                result.setStatus(BarcodeResult.Status.FAILED);
            }
        }
        return result;
    }
}

