/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.barcodemanager.define;

public class SecurityLevels {

    public static enum SecurityLevel {
        LEVEL_0(0),
        LEVEL_1(1),
        LEVEL_2(2),
        LEVEL_3(3);

        private int num;

        private SecurityLevel(int num) {
            this.num = num;
        }

        public int getNum() {
            return this.num;
        }
    }

    public static enum SecurityLevelType {
        CODE_128{

            @Override
            public String getString() {
                return "Code 128";
            }

            @Override
            public byte[] getHexCommand() {
                return new byte[]{-15, -17};
            }
        }
        ,
        CODE_39{

            @Override
            public String getString() {
                return "Code 39";
            }

            @Override
            public byte[] getHexCommand() {
                return new byte[]{-15, -18};
            }
        }
        ,
        I_2_OF_5{

            @Override
            public String getString() {
                return "I 2 of 5";
            }

            @Override
            public byte[] getHexCommand() {
                return new byte[]{-8, 4, 97};
            }
        }
        ,
        CODABAR{

            @Override
            public String getString() {
                return "Codabar";
            }

            @Override
            public byte[] getHexCommand() {
                return new byte[]{-8, 6, -16};
            }
        }
        ,
        GS1_DATABAR{

            @Override
            public String getString() {
                return "GS1 Databar";
            }

            @Override
            public byte[] getHexCommand() {
                return new byte[]{-8, 6, -86};
            }
        }
        ,
        UPC_EAN_JAN{

            @Override
            public String getString() {
                return "UPC/EAN/JAN/Code93";
            }

            @Override
            public byte[] getHexCommand() {
                return new byte[]{77};
            }
        };


        public abstract byte[] getHexCommand();

        public abstract String getString();
    }
}

