/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.barcodemanager.define;

import jp.co.asterisk.asreader.barcodemanager.define.BarcodeConst;
import jp.co.asterisk.asreader.barcodemanager.define.BarcodeResult;

public class SSICommandModel {

    public static enum SystemBeep {
        NONE{

            @Override
            public byte getCommand() {
                return -1;
            }
        }
        ,
        SHORT_HIGH{

            @Override
            public byte getCommand() {
                return 0;
            }
        }
        ,
        SHORT_LOW{

            @Override
            public byte getCommand() {
                return 5;
            }
        }
        ,
        LONG_HIGH{

            @Override
            public byte getCommand() {
                return 10;
            }
        }
        ,
        LONG_LOW{

            @Override
            public byte getCommand() {
                return 15;
            }
        }
        ,
        FAST_WARBLE{

            @Override
            public byte getCommand() {
                return 20;
            }
        }
        ,
        SLOW_WARBLE{

            @Override
            public byte getCommand() {
                return 21;
            }
        }
        ,
        HIGH_CLICK{

            @Override
            public byte getCommand() {
                return 28;
            }
        }
        ,
        LOW_CLICK{

            @Override
            public byte getCommand() {
                return 29;
            }
        };


        public abstract byte getCommand();

        public static SystemBeep getEnum(byte buf) {
            for (SystemBeep command : SystemBeep.values()) {
                if (buf != command.getCommand()) continue;
                return command;
            }
            return NONE;
        }

        public static SystemBeep getSystemBeepValue(BarcodeConst.SystemBeepSoundType type) {
            switch (type) {
                case TYPE1: {
                    return SHORT_HIGH;
                }
                case TYPE2: {
                    return SHORT_LOW;
                }
                case TYPE3: {
                    return LONG_HIGH;
                }
                case TYPE4: {
                    return LONG_LOW;
                }
                case TYPE5: {
                    return FAST_WARBLE;
                }
                case TYPE6: {
                    return SLOW_WARBLE;
                }
                case TYPE7: {
                    return HIGH_CLICK;
                }
                case TYPE8: {
                    return LOW_CLICK;
                }
            }
            return NONE;
        }

        public static BarcodeResult.Result getResultObject(SystemBeep systemBeep) {
            switch (systemBeep) {
                case SHORT_HIGH: {
                    return BarcodeResult.Result.SYSTEM_BEEP_TYPE1;
                }
                case SHORT_LOW: {
                    return BarcodeResult.Result.SYSTEM_BEEP_TYPE2;
                }
                case LONG_HIGH: {
                    return BarcodeResult.Result.SYSTEM_BEEP_TYPE3;
                }
                case LONG_LOW: {
                    return BarcodeResult.Result.SYSTEM_BEEP_TYPE4;
                }
                case FAST_WARBLE: {
                    return BarcodeResult.Result.SYSTEM_BEEP_TYPE5;
                }
                case SLOW_WARBLE: {
                    return BarcodeResult.Result.SYSTEM_BEEP_TYPE6;
                }
                case HIGH_CLICK: {
                    return BarcodeResult.Result.SYSTEM_BEEP_TYPE7;
                }
                case LOW_CLICK: {
                    return BarcodeResult.Result.SYSTEM_BEEP_TYPE8;
                }
            }
            return BarcodeResult.Result.SYSTEM_BEEP_SOUND_NONE;
        }
    }

    public static enum PresentationMode {
        UNKNOWN{

            @Override
            public byte getCommand() {
                return -1;
            }
        }
        ,
        STANDARD{

            @Override
            public byte getCommand() {
                return 0;
            }
        }
        ,
        PRESENTATION{

            @Override
            public byte getCommand() {
                return 7;
            }
        };


        public abstract byte getCommand();

        public static PresentationMode getEnum(byte buf) {
            for (PresentationMode command : PresentationMode.values()) {
                if (buf != command.getCommand()) continue;
                return command;
            }
            return UNKNOWN;
        }
    }

    public static enum SSIParameter {
        UNKNOWN{

            @Override
            public byte getCommand() {
                return -1;
            }
        }
        ,
        RESPONSE_ENABLE{

            @Override
            public byte getCommand() {
                return 1;
            }
        }
        ,
        RESPONSE_DISABLE{

            @Override
            public byte getCommand() {
                return 0;
            }
        };


        public abstract byte getCommand();

        public static SSIParameter getEnum(byte buf) {
            for (SSIParameter command : SSIParameter.values()) {
                if (buf != command.getCommand()) continue;
                return command;
            }
            return UNKNOWN;
        }
    }

    public static enum CodeID {
        UNKNOWN{

            @Override
            public byte getCommand() {
                return -1;
            }
        }
        ,
        NONE{

            @Override
            public byte getCommand() {
                return 0;
            }
        }
        ,
        AIM{

            @Override
            public byte getCommand() {
                return 1;
            }
        }
        ,
        SYMBOL{

            @Override
            public byte getCommand() {
                return 2;
            }
        };


        public abstract byte getCommand();

        public static CodeID getEnum(byte buf) {
            for (CodeID command : CodeID.values()) {
                if (buf != command.getCommand()) continue;
                return command;
            }
            return UNKNOWN;
        }
    }

    public static enum TransmissionFormat {
        UNKNOWN{

            @Override
            public byte getCommand() {
                return -1;
            }
        }
        ,
        DATA_AS_IS{

            @Override
            public byte getCommand() {
                return 0;
            }
        }
        ,
        DATA_SUFFIX1{

            @Override
            public byte getCommand() {
                return 1;
            }
        }
        ,
        DATA_SUFFIX2{

            @Override
            public byte getCommand() {
                return 2;
            }
        }
        ,
        DATA_SUFFIX1_SUFFIX2{

            @Override
            public byte getCommand() {
                return 3;
            }
        }
        ,
        PREFIX_DATA{

            @Override
            public byte getCommand() {
                return 4;
            }
        }
        ,
        PREFIX_DATA_SUFFIX1{

            @Override
            public byte getCommand() {
                return 5;
            }
        }
        ,
        PREFIX_DATA_SUFFIX2{

            @Override
            public byte getCommand() {
                return 6;
            }
        }
        ,
        PREFIX_DATA_SUFFIX1_SUFFIX2{

            @Override
            public byte getCommand() {
                return 7;
            }
        };


        public abstract byte getCommand();

        public static TransmissionFormat getEnum(byte buf) {
            for (TransmissionFormat command : TransmissionFormat.values()) {
                if (buf != command.getCommand()) continue;
                return command;
            }
            return UNKNOWN;
        }
    }

    public static enum SSICommand {
        UNKNOWN{

            @Override
            public byte getCommand() {
                return -1;
            }
        }
        ,
        CHARACTER{

            @Override
            public byte getCommand() {
                return 45;
            }
        }
        ,
        SCAN_DATA_TRANSMISSION_FORMAT{

            @Override
            public byte getCommand() {
                return -21;
            }
        }
        ,
        NOTIS_EDITING{

            @Override
            public byte getCommand() {
                return 55;
            }
        }
        ,
        PRESENTATION_TRIGGER_MODE{

            @Override
            public byte getCommand() {
                return -118;
            }
        };


        public abstract byte getCommand();

        public static SSICommand getEnum(byte buf) {
            for (SSICommand command : SSICommand.values()) {
                if (buf != command.getCommand()) continue;
                return command;
            }
            return UNKNOWN;
        }

        public static byte[] linkageByte(byte[] firstBuf, byte[] secondBuf) {
            byte[] retBuf = new byte[firstBuf.length + secondBuf.length];
            System.arraycopy(firstBuf, 0, retBuf, 0, firstBuf.length);
            System.arraycopy(secondBuf, 0, retBuf, firstBuf.length, secondBuf.length);
            return retBuf;
        }
    }
}

