/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.barcodemanager;

import jp.co.asterisk.asreader.a24d.communicationmanager.packet.AsReaderPacketConst;
import jp.co.asterisk.asreader.a24d.communicationmanager.packet.PacketModel;
import jp.co.asterisk.asreader.barcodemanager.BarcodeCommandType;
import jp.co.asterisk.asreader.barcodemanager.define.BarcodeConst;
import jp.co.asterisk.asreader.barcodemanager.define.SSICommandModel;

class BarcodeCommandFactory {
    private static BarcodeCommandFactory instance;

    private BarcodeCommandFactory() {
    }

    public static BarcodeCommandFactory getInstance() {
        if (instance == null) {
            instance = new BarcodeCommandFactory();
        }
        return instance;
    }

    public PacketModel create(BarcodeCommandType type) {
        switch (type) {
            case START_DECODE: {
                return this.createStartDecode();
            }
            case STOP_DECODE: {
                return this.createStopRead();
            }
            case FACTORY_DEFAULT: {
                return this.createFactoryDefault();
            }
            case GET_STOP_CONDITION: {
                return this.createGetStopCondition();
            }
        }
        return null;
    }

    public byte[] create(BarcodeConst.BarcodeSettings settingsType) {
        switch (settingsType) {
            case CHARACTER_CODE_ID_SYMBOL: {
                return new byte[]{SSICommandModel.SSICommand.CHARACTER.getCommand(), SSICommandModel.CodeID.SYMBOL.getCommand()};
            }
            case CHARACTER_CODE_ID_AIM: {
                return new byte[]{SSICommandModel.SSICommand.CHARACTER.getCommand(), SSICommandModel.CodeID.AIM.getCommand()};
            }
            case CHARACTER_NONE: {
                return new byte[]{SSICommandModel.SSICommand.CHARACTER.getCommand(), SSICommandModel.CodeID.NONE.getCommand()};
            }
            case CHARACTER_GET: {
                return new byte[]{SSICommandModel.SSICommand.CHARACTER.getCommand()};
            }
            case PREFIX_STATUS: {
                return new byte[]{SSICommandModel.SSICommand.SCAN_DATA_TRANSMISSION_FORMAT.getCommand()};
            }
            case NOTIS_EDITING: {
                return new byte[]{SSICommandModel.SSICommand.NOTIS_EDITING.getCommand()};
            }
            case TRIGGER_STANDARD: {
                return new byte[]{SSICommandModel.SSICommand.PRESENTATION_TRIGGER_MODE.getCommand(), SSICommandModel.PresentationMode.STANDARD.getCommand()};
            }
            case TRIGGER_PRESENTATION: {
                return new byte[]{SSICommandModel.SSICommand.PRESENTATION_TRIGGER_MODE.getCommand(), SSICommandModel.PresentationMode.PRESENTATION.getCommand()};
            }
            case PRESENTATION_GET: {
                return new byte[]{SSICommandModel.SSICommand.PRESENTATION_TRIGGER_MODE.getCommand()};
            }
        }
        return null;
    }

    public PacketModel createSetSSIParam(byte memoryTypeByte, byte beep, byte[] payload) {
        byte[] newPayload = new byte[payload.length + 2];
        System.arraycopy(payload, 0, newPayload, 2, payload.length);
        newPayload[0] = memoryTypeByte;
        newPayload[1] = beep;
        return this.createPacketModel(AsReaderPacketConst.AsReaderPacket.MESSAGE_COMBO_BARCODE.getByte(), AsReaderPacketConst.AsReaderPacket.CMD_SET_BARCODE_SSI_PARAMETER.getByte(), newPayload);
    }

    public PacketModel createGetSSIParam(byte[] payload) {
        return this.createPacketModel(AsReaderPacketConst.AsReaderPacket.MESSAGE_COMBO_BARCODE.getByte(), AsReaderPacketConst.AsReaderPacket.CMD_GET_BARCODE_SSI_PARAMETER.getByte(), payload);
    }

    public PacketModel createBypassCmd(byte[] payload) {
        return this.createPacketModel(AsReaderPacketConst.AsReaderPacket.MESSAGE_COMBO_BARCODE.getByte(), AsReaderPacketConst.AsReaderPacket.CMD_BARCODE_BYPASS.getByte(), payload);
    }

    public PacketModel createUpdateCmd(byte[] payload) {
        return this.createPacketModel(AsReaderPacketConst.AsReaderPacket.MESSAGE.getByte(), AsReaderPacketConst.AsReaderPacket.CMD_BARCODE_UPDATE.getByte(), payload);
    }

    private PacketModel createPacketModel(byte type, byte command, byte[] payload) {
        PacketModel packetModel = new PacketModel();
        packetModel.setCommand(type, command, payload);
        return packetModel;
    }

    private PacketModel createStartDecode() {
        byte[] payload = new byte[5];
        return this.createPacketModel(AsReaderPacketConst.AsReaderPacket.MESSAGE_COMBO_BARCODE.getByte(), AsReaderPacketConst.AsReaderPacket.CMD_START_AUTO_SCAN_BARCODE.getByte(), payload);
    }

    private PacketModel createStopRead() {
        return this.createPacketModel(AsReaderPacketConst.AsReaderPacket.MESSAGE_COMBO_BARCODE.getByte(), AsReaderPacketConst.AsReaderPacket.CMD_STOP_AUTO_SCAN_BARCODE.getByte(), null);
    }

    private PacketModel createFactoryDefault() {
        byte[] payload = new byte[]{0};
        return this.createPacketModel(AsReaderPacketConst.AsReaderPacket.MESSAGE.getByte(), AsReaderPacketConst.AsReaderPacket.CMD_BARCODE_FACTORY_DEFAULT.getByte(), payload);
    }

    private PacketModel createGetStopCondition() {
        return this.createPacketModel(AsReaderPacketConst.AsReaderPacket.MESSAGE.getByte(), AsReaderPacketConst.AsReaderPacket.CMD_GET_BARCODE_STOP_CONDITION.getByte(), null);
    }
}

