import 'dart:async';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:asreader_sdk4/asreader_sdk4.dart';

class InformationWidget extends StatefulWidget {
  const InformationWidget({super.key});

  @override
  State<StatefulWidget> createState() => InformationState();
}

class InformationState extends State<InformationWidget> {
  final _asreaderSdk4Plugin = AsreaderSdk4();
  static const iosCallPlatform = MethodChannel('asreader_sdk4');
  static const APP_VERSION = '1.2.0';
  static const APP_BUILD = '1';
  static const REGION_KOREA_OLD = 0x01;
  static const REGION_USA_OLD = 0x02;
  static const REGION_EUROPE_OLD = 0x04;
  static const REGION_JAPAN_OLD = 0x08;
  static const REGION_CHINA2_OLD = 0x10;
  static const REGION_CHINA1_OLD = 0x16;
  static const REGION_USA2_OLD = 0x32;
  static const REGION_KOREA = 0x11;
  static const REGION_USA = 0x21;
  static const REGION_USA2 = 0x22;
  static const REGION_EUROPE = 0x31;
  static const REGION_JAPAN = 0x41;
  static const REGION_CHINA1 = 0x51;
  static const REGION_CHINA2 = 0x52;
  static const REGION_BRAZIL1 = 0x61;
  static const REGION_BRAZIL2 = 0x62;
  static const REGION_AU_HK = 0x71;
  String appv = '';
  String fluttersdkv = '';
  String sdkv = '';
  String model = '';
  String hwv = '';
  String fwv = '';
  String battery = '';
  String region = '';
  String rfModule = '';
  bool regionStatus = false;
  bool rfModuleStatus = false;

  @override
  void initState() {
    super.initState();
    initPlatformState();
  }
  Future<void> initPlatformState() async {
    Future<dynamic> _handler(MethodCall methodCall) {
      print('methodCall.method:${methodCall.method}, methodCall.arguments:${methodCall.arguments}');
      if (_asreaderSdk4Plugin.PLUGGED_STATUS == methodCall.method) {
        bool isPluged = methodCall.arguments['result'];
        print('Information isPluged:$isPluged, methodCall.arguments:${methodCall.arguments}');
        plugged(isPluged);
      } else if (_asreaderSdk4Plugin.CONNECTED_STATUS == methodCall.method) {
        bool isConnected = methodCall.arguments['result'];
        print('Information isConnected:$isConnected, methodCall.arguments:${methodCall.arguments}');
        connected(isConnected);
      } else if (_asreaderSdk4Plugin.BATTERY_RECEIVED == methodCall.method) {
        int batteryNumber = methodCall.arguments['result'];
        print('battery:$batteryNumber, methodCall.arguments:${methodCall.arguments}');
        setState(() {
          battery = '$batteryNumber%';
        });
      } else if (_asreaderSdk4Plugin.REGION_RECEIVED == methodCall.method) {
        int regionNumber = methodCall.arguments['result'];
        print('region:$regionNumber, methodCall.arguments:${methodCall.arguments}');
        regionReceived(regionNumber);
      } else if (_asreaderSdk4Plugin.RFID_MODULE_VERSION_RECEIVED == methodCall.method) {
        print('methodCall.arguments:${methodCall.arguments}');
        rfidModuleVersionReceived();
      }
      return Future.value('success');
    }
    iosCallPlatform.setMethodCallHandler(_handler);
    Future.delayed(const Duration(milliseconds: 500), () {
      setState(() {
        getAPPVersion();
        getFlutterSDKVersion();
        getSDKVersion();
        getModelVersion();
        getHardwareVersion();
        getFirmwareVersion();
        getBattery();
        Future<int> info = _asreaderSdk4Plugin.supportMode();
        info.then((futureResult) {
          print('futureResult = $futureResult');
          if (futureResult == 1 || futureResult == 3) {
            regionStatus = true;
            rfModuleStatus = true;
            Future<bool> getRegion = _asreaderSdk4Plugin.getRegion();
            getRegion.then((futureResult) {
              if (futureResult) {
                Future.delayed(const Duration(milliseconds: 500), () {
                  _asreaderSdk4Plugin.getRFIDModuleVersion();
                });
              }
            });
          } else {
            regionStatus = false;
            rfModuleStatus = false;
          }
        });
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    var container1 = Container(
      color: Colors.white,
      padding: const EdgeInsets.fromLTRB(15, 7, 15, 7),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: <Widget>[
          const Expanded(
            child:Text(
              'APP',
              style: TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.left,
            ),
          ),
          Expanded(
            child:Text(
              appv,
              style: const TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.right,
            ),
          ),
        ],
      ),
    );
    var container9 = Container(
      color: Colors.white,
      padding: const EdgeInsets.fromLTRB(15, 7, 15, 7),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: <Widget>[
          const Expanded(
            child:Text(
              'Flutter SDK',
              style: TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.left,
            ),
          ),
          Expanded(
            child:Text(
              fluttersdkv,
              style: const TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.right,
            ),
          ),
        ],
      ),
    );
    var container2 = Container(
      color: Colors.white,
      padding: const EdgeInsets.fromLTRB(15, 7, 15, 7),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: <Widget>[
          const Expanded(
            child:Text(
              'SDK',
              style: TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.left,
            ),
          ),
          Expanded(
            child:Text(
              sdkv,
              style: const TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.right,
            ),
          ),
        ],
      ),
    );
    var container3 = Container(
      color: Colors.white,
      padding: const EdgeInsets.fromLTRB(15, 7, 15, 7),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: <Widget>[
          const Expanded(
            child:Text(
              'Model',
              style: TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.left,
            ),
          ),
          Expanded(
            child:Text(
              model,
              style: const TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.right,
            ),
          ),
        ],
      ),
    );
    var container4 = Container(
      color: Colors.white,
      padding: const EdgeInsets.fromLTRB(15, 7, 15, 7),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: <Widget>[
          const Expanded(
            child:Text(
              'Hardware Version',
              style: TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.left,
            ),
          ),
          Expanded(
            child:Text(
              hwv,
              style: const TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.right,
            ),
          ),
        ],
      ),
    );
    var container5 = Container(
      color: Colors.white,
      padding: const EdgeInsets.fromLTRB(15, 7, 15, 7),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: <Widget>[
          const Expanded(
            child:Text(
              'Firmware Version',
              style: TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.left,
            ),
          ),
          Expanded(
            child:Text(
              fwv,
              style: const TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.right,
            ),
          ),
        ],
      ),
    );
    var container6 = Container(
      color: Colors.white,
      padding: const EdgeInsets.fromLTRB(15, 7, 15, 7),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: <Widget>[
          const Expanded(
            child:Text(
              'Battery',
              style: TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.left,
            ),
          ),
          Expanded(
            child:Text(
              battery,
              style: const TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.right,
            ),
          ),
        ],
      ),
    );
    var container7 = Container(
      color: Colors.white,
      padding: const EdgeInsets.fromLTRB(15, 7, 15, 7),
      child: Visibility(
        visible: regionStatus,
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
          children: <Widget>[
            const Expanded(
              child: Text(
                'Region',
                style: TextStyle(
                    height: 1.5,
                    color: Colors.black,
                    fontSize: 16.0,
                    fontWeight: FontWeight.w400,
                    backgroundColor: Colors.white),
                textAlign: TextAlign.left,
              ),
            ),
            Expanded(
              child: Text(
                region,
                style: const TextStyle(
                    height: 1.5,
                    color: Colors.black,
                    fontSize: 16.0,
                    fontWeight: FontWeight.w400,
                    backgroundColor: Colors.white),
                textAlign: TextAlign.right,
              ),
            ),
          ],
        ),
      ),
    );
    var container8 = Container(
      color: Colors.white,
      padding: const EdgeInsets.fromLTRB(15, 7, 15, 7),
      child: Visibility(
        visible: rfModuleStatus,
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
          children: <Widget>[
            const Expanded(
              child: Text(
                'RFModule',
                style: TextStyle(
                    height: 1.5,
                    color: Colors.black,
                    fontSize: 16.0,
                    fontWeight: FontWeight.w400,
                    backgroundColor: Colors.white),
                textAlign: TextAlign.left,
              ),
            ),
            Expanded(
              child: Text(
                rfModule,
                style: const TextStyle(
                    height: 1.5,
                    color: Colors.black,
                    fontSize: 16.0,
                    fontWeight: FontWeight.w400,
                    backgroundColor: Colors.white),
                textAlign: TextAlign.right,
              ),
            ),
          ],
        ),
      ),
    );
    return Scaffold(
      appBar: AppBar(
        title: const Text('Information'),
        backgroundColor: Colors.white,
        leading: IconButton(
          icon: Image.asset(
            'images/back.png',
            width: 25,
            height: 25,
            fit: BoxFit.cover,
          ),
          onPressed: () {
            Navigator.pop(context);
          },
        ),
      ),
      body: Container(
        color: Colors.white,
        child: Column(
          children: <Widget>[
            container1,
            container9,
            container2,
            container3,
            container4,
            container5,
            container6,
            container7,
            container8,
          ],
        ),
      ),
    );
  }
  void plugged(bool isPluged) {
    setState(() {
      if (!isPluged) {
        Navigator.pop(context, "NO");
      }
    });
  }
  void connected(bool isConnected) {
    setState(() {
      if (!isConnected) {
        Navigator.pop(context, "NO");
      }
    });
  }
  void getAPPVersion() async {
    setState(() {
      try {
        appv = '$APP_VERSION($APP_BUILD)';
        print('APP version: $appv');
      } on PlatformException {
        appv = '';
        print('Failed to get app version.');
      }
    });
  }
  void getFlutterSDKVersion() async {
    setState(() {
      try {
        Future<String?> sdkString = _asreaderSdk4Plugin.getFlutterSDKVersion();
        sdkString.then((futureResult) {
          if (futureResult != null && futureResult.isNotEmpty) {
            fluttersdkv = futureResult;
          } else {
            fluttersdkv = '';
          }
          print('Flutter SDK version: $fluttersdkv');
        });
      } on PlatformException {
        fluttersdkv = '';
        print('Failed to get flutter sdk version.');
      }
    });
  }
  void getSDKVersion() async {
    setState(() {
      try {
        Future<String?> sdkString = _asreaderSdk4Plugin.getSDKVersion();
        sdkString.then((futureResult) {
          if (futureResult != null && futureResult.isNotEmpty) {
            sdkv = futureResult;
          } else {
            sdkv = '';
          }
          print('SDK version: $sdkv');
        });
      } on PlatformException {
        sdkv = '';
        print('Failed to get sdk version.');
      }
    });
  }
  void getModelVersion() async {
    setState(() {
      try {
        Future<String?> modelString = _asreaderSdk4Plugin.deviceModelNumber();
        modelString.then((futureResult) {
          if (futureResult != null && futureResult.isNotEmpty) {
            model = futureResult;
          } else {
            model = '';
          }
          print('model: $model');
        });
      } on PlatformException {
        model = '';
        print('Failed to get model.');
      }
    });
  }
  void getHardwareVersion() async {
    setState(() {
      try {
        Future<String?> hwvString = _asreaderSdk4Plugin.deviceHardware();
        hwvString.then((futureResult) {
          if (futureResult != null && futureResult.isNotEmpty) {
            hwv = futureResult;
          } else {
            hwv = '';
          }
          print('Hardware version: $hwv');
        });
      } on PlatformException {
        hwv = '';
        print('Failed to get hardware version.');
      }
    });
  }
  void getFirmwareVersion() async {
    setState(() {
      try {
        Future<String?> fwvString = _asreaderSdk4Plugin.deviceFirmware();
        fwvString.then((futureResult) {
          if (futureResult != null && futureResult.isNotEmpty) {
            fwv = futureResult;
          } else {
            fwv = '';
          }
          print('Firmware version: $fwv');
        });
      } on PlatformException {
        fwv = '';
        print('Failed to get firmware version.');
      }
    });
  }
  void getBattery() async {
    setState(() {
      try {
        Future<int> batteryNumber = _asreaderSdk4Plugin.getCurrentBattery();
        batteryNumber.then((futureResult) {
          battery = '$futureResult%';
          print('Battery: $battery');
        });
      } on PlatformException {
        battery = '';
        print('Failed to get battery.');
      }
    });
  }
  void regionReceived(int regionNumber) {
    setState(() {
      switch (regionNumber) {
        case REGION_KOREA_OLD:
        case REGION_KOREA:
          region = 'KOREA';
          break;
        case REGION_USA_OLD:
          Future<String> deviceNameString = _asreaderSdk4Plugin.deviceName();
          deviceNameString.then((futureResult) {
            if (futureResult.contains('ASR-M30S')) {
              region = 'US';
            } else {
              region = 'US(OLD Type)';
            }
          });
          break;
        case REGION_USA:
          region = 'US1(North)';
          break;
        case REGION_USA2:
          region = 'US2';
          break;
        case REGION_EUROPE_OLD:
        case REGION_EUROPE:
          region = 'EU';
          break;
        case REGION_JAPAN_OLD:
        case REGION_JAPAN:
          region = 'JAPAN';
          break;
        case REGION_CHINA2_OLD:
        case REGION_CHINA1_OLD:
        case REGION_CHINA1:
        case REGION_CHINA2:
          region = 'CHINA';
          break;
        case REGION_AU_HK:
          region = 'ASIA';
          break;
        default:
          region = 'Unkown';
          break;
      }
    });
  }
  void rfidModuleVersionReceived() {
    setState(() {
      Future<String> rfid = _asreaderSdk4Plugin.rfidModuleVersion();
      rfid.then((futureResult) {
        rfModule = futureResult;
      });
    });
  }
}
