//
//  BarcodeZebraSsiEnum.h
//  AsReaderDockSDK
//
//  Created by Sarah on 7/16/24.
//  Copyright © 2024 SPS INC. All rights reserved.
//
#import <Foundation/Foundation.h>

/**
 *  @brief      This file contains enumerations (enum) that define barcode symbologies, statuses, security levels, and other parameters used with Zebra devices.
 */

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, ZebraSsiParamEnum) {
    UPC_A = 1,
    UPC_E = 2,
    UPC_E1 = 12,
    EAN_13 = 3,
    EAN_8 = 4,
    Bookland_EAN = 83,
    ISSN_EAN = 617,
    Interleaved_2of5 = 6,
    Discrete_2of5 = 5,
    Coda_bar = 7,
    Code_128 = 8,
    Code_39 = 0,
    Code_93 = 9,
    Code_11 = 10,
    Msi = 11,
    Chinese_2of5 = 408,
    Matrix_2of5 = 618,
    Korean_3of5 = 581,
    GS1_128 = 14,
    GS1_Databar = 338,
    PDF_417 = 15,
    MicroPDF417 = 227,
    DataMatrix = 292,
    GS1_DataMatrix = 1336,
    QR_Code = 293,
    Japan_Postal = 290,
    MicroQR = 573,
    Aztec = 574,
    Composite_CC_C = 341,
    Composite_CC_AB = 342,
    Composite_TLC_39 = 371,
    Maxicode = 294,
    US_Postnet = 89,
    US_Planet = 90,
    UK_Postal = 91,
    Australia_Post = 291,
    NetherlandsKIXCode = 326,
    
    SSI_CODE_ID = 45,
    SSI_OCR_A = 680,
    SSI_OCR_B = 681,
    SSI_TRIGGER_MODE = 138,
    
    SSI_SECURITY_CODE_128 = 751,
    SSI_SECURITY_CODE_39 = 750,
    SSI_SECURITY_I_2_OF_5 = 1121,
    SSI_SECURITY_CODABAR = 1776,
    SSI_SECURITY_GS1_DATABAR = 1706,
    SSI_SECURITY_UPC_EAN_JAN = 77
};

typedef NS_ENUM(NSInteger, ZebraSymbologyStutsEnum) {	
	DISABLE = 0,
    ENABLE = 1,
	UNKNOWN = 255
};


typedef NS_ENUM(NSInteger, ZebraSsiSaveEnum) {
	SSI_PRM_TEMP = 0X00,
	SSI_PRM_SAVE = 0X08
};

typedef NS_ENUM(NSInteger, ZebraSecurityLevel) {
    LEVEL_0 = 0,
    LEVEL_1 = 1,
    LEVEL_2 = 2,
    LEVEL_3 = 3,
	LEVEL_UNKOWN = 255
};

NS_ASSUME_NONNULL_END
