//
//  ModelInformations.h
//  AsReaderDockSDK
//
//  Created by Mikiko on 11/7/24.
//  Copyright © 2024 SPS INC. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AsReaderInfoDefine.h"
#import "NfcDefine.h"
// extern NSString* const ASREADER_PLIST_EXTERNAL_ACCESSORY_PROTOCOLS_KEY;
// extern NSString* const ASREADER_PREFIX_ASREADER_PROTOCOLS;
// extern NSString* const ASREADER_PROTOCOL_BARCODE;
// extern NSString* const ASREADER_PROTOCOL_RFID;
// extern NSString* const ASREADER_PROTOCOL_DONGLE_BARCODE;
// extern NSString* const ASREADER_PROTOCOL_DONGLE_RFID;
// extern NSString* const ASREADER_PROTOCOL_ASREADER_2030D;
// extern NSString* const ASREADER_PROTOCOL_ASREADER_2040D;
// extern NSString* const ASREADER_PROTOCOL_NFC_040D;

/**
 *  @brief      This class is responsible for managing and storing device-related information for AsReader products. This class also handles the configuration of device modes, features, and settings based on the device model.
 */
@interface ModelInformations : NSObject
+ (instancetype)sharedInstance;
// clear model information properties
- (void)initProperties;
// set model features based on model name
- (void)updateModelFeature;
// legacy.. BLE model information is updated by RCP only .. moved RCP API
//- (void)updateInfomationforBle:(NSData*)data;

- (BOOL)isSupportType:(ReaderMode)supportType;
- (NSArray *)getSupportTypeArray;

//////////////////////////////////////////////////////////
// App/SDK Settings //////////////////////////////////////
@property(nonatomic, assign) BOOL isShowPrintNSLog;
//////////////////////////////////////////////////////////
// common infomations ////////////////////////////////////
@property(nonatomic,retain) NSString *deviceName;
@property(nonatomic,retain) NSString *deviceFirmware;
@property(nonatomic,retain) NSString *deviceHardware;
@property(nonatomic,retain) NSString *deviceID;
@property(nonatomic,retain) NSString *deviceManufacturer;
@property(nonatomic,retain) NSString *deviceModelNumber;
@property(nonatomic,retain) NSString *deviceSerialNumber;
@property(nonatomic,retain) NSString *deviceProtocol;
@property(nonatomic,retain) NSString *bundleIdentifier;


@property(nonatomic,assign) ReaderGenerationType readerGeneration;
@property(nonatomic,assign) ReaderMode supportMode;
@property(nonatomic,assign) BOOL dualSameTime;
@property(nonatomic,assign) ReaderMode currentReaderMode;
@property(nonatomic,assign) ReaderMode receiveDataType;

// common status
@property(nonatomic,assign) BOOL isPowerOn;
@property(nonatomic,assign) int batteryLevel;

// Power on switch controllable
@property(nonatomic,assign) BOOL isPowerSwithNotControllable;
//////////////////////////////////////////////////////////
// Common Settings////////////////////////////////////////
// Beep //Virbration // LED  // Illumination
@property(nonatomic,assign) BOOL isBeep;
@property(nonatomic,assign) BOOL isVibration;
@property(nonatomic,assign) BOOL isLED;
@property(nonatomic,assign) BOOL isIllumination;

// Read Propery
@property(nonatomic,assign) int count;
@property(nonatomic,assign) int scanTime;
@property(nonatomic,assign) int cycle;

// Trigger Button Mode  Default Property
@property(nonatomic,assign) BOOL isTriggerModeDefault;

//////////////////////////////////////////////////////////
// Barcode Settings///////////////////////////////////////
@property(nonatomic,assign) BarcodeEngineType barcodeEngineType;
@property(nonatomic,assign) int barcodeTarget;
// Barcode Prefix&Suffix
@property(nonatomic,strong) NSString *customPrefixValue;
@property(nonatomic,strong) NSString *customSuffixValue;
@property(nonatomic,assign) BOOL enableCustomPrefix;
@property(nonatomic,assign) BOOL enableCustomSuffix;
@property(nonatomic,assign) BOOL enableSymbologyPrefix;

//////////////////////////////////////////////////////////
// RFID version
@property(nonatomic,retain) NSString *rfidModuleVersion;

// RFID Settings//////////////////////////////////////////
@property(nonatomic,assign) BOOL isReadRSSIMode;
@property(nonatomic,assign) float rfidPower;
@property(nonatomic,assign) float rfidPowerMax;
@property(nonatomic,assign) float rfidPowerMin;
// RFID Hopping
@property(nonatomic,assign) BOOL isSmartHopping;
@property(nonatomic,assign) int rfidOnTime;
@property(nonatomic,assign) int rfidOffTime;
@property(nonatomic,assign) int rfidChannel;
// RFID regulatory
@property(nonatomic,assign)	int rfidRegion;
@property(nonatomic,assign) int rfidCarrierSenseTime;
@property(nonatomic,assign) int rfidTargetRFPowerLevel;
@property(nonatomic,assign) int rfidFrequencyHopping;
@property(nonatomic,assign) int rfidListenBeforeTalk;
@property(nonatomic,assign) int rfidContinuousWave;
// RFID protocol
@property(nonatomic,assign) int rfidBlf;
@property(nonatomic,assign) int rfidMod;
@property(nonatomic,assign) int rfidDr;
@property(nonatomic,assign) int rfidSession;

//////////////////////////////////////////////////////////
// NFC Settings///////////////////////////////////////////
// NFC ISO15693 Command Options  Enum
@property(nonatomic,assign) NFCISO15693CommandOptions nfcCommandOptions;

//////////////////////////////////////////////////////////
// LF Settings////////////////////////////////////////////

// LF property here

//////////////////////////////////////////////////////////
@property(nonatomic,assign) BOOL isC3Device;
@property(nonatomic,assign) BOOL is025SDevice;
@end
