//
//  LFTagParser.h
//  AsReaderDockSDK
//
//  Created by Y.Oshiro on 2021/09/03.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, ProtocolTypeLF) {
    ProtocolTypeLF_FDBX = 0
};

#define Key_FDBX_NationalCode @"Key_FDBX_NationalCode"
#define Key_FDBX_CountryCode @"Key_FDBX_CountryCode"
#define Key_FDBX_StatusFlag @"Key_FDBX_StatusFlag"
#define Key_FDBX_AnimalIndicator @"Key_FDBX_AnimalIndicator"
#define Key_FDBX_Reserved @"Key_FDBX_Reserved"


/**
 *  @brief      LFTagParser.m is a class designed to parse specific tag data formats, potentially related to RFID or NFC tags, and extract structured information from the raw binary data. The class contains several methods to parse the data and convert it into a dictionary of key-value pairs representing different fields of the tag.
 */
@interface LFTagParser : NSObject
+ (instancetype)sharedInstance;

- (NSDictionary *)parseDataByProtocolType:(NSData *)data protocolType:(ProtocolTypeLF)protocolType;
@end

NS_ASSUME_NONNULL_END
