//
//  AsReaderBLEProtocol.h
//  AsReaderBLESDK
//
//  Created by MRX_ZYL on 27/1/2021.
//  Copyright © 2021 ZYL. All rights reserved.
//

#ifndef AsReaderBLEProtocols_h
#define AsReaderBLEProtocols_h
#import <CoreBluetooth/CoreBluetooth.h>


typedef NS_ENUM(NSUInteger, BleStatusCodes) {
    BLE_STS_SCANNING = 0x00,
    BLE_STS_SCAN_STOP = 0x01,
};

/**
 *  @brief      This file defines a protocol that is intended to be used by an app to handle events and communication related to BLE operations. It allows the app to receive updates on the status of BLE scanning, discovered devices, and possibly data received from the BLE devices.
 */
@protocol AsReaderBLEProtocols <NSObject>

@optional
/**
 *  @brief      Used in the APP.
 *  @details    This function reports information about discovered BLE devices.
 */
- (void)scanningBleDeive:(CBPeripheral*)device;

/**
 *  @brief      Used in the APP.
 *  @details    This function reports BLE search status.
 */
- (void)scanBleStatus:(BleStatusCodes)status;

@end

#endif /* AsReaderBLEProtocol_h */
