//
//  BarcodeZebraSsiParam.h
//  AsReaderDockSDK
//
//  Created by Sarah on 7/17/24.
//  Copyright © 2024 SPS INC. All rights reserved.
//


#import <Foundation/Foundation.h>
#import "BarcodeZebraSsiEnum.h"

NS_ASSUME_NONNULL_BEGIN

/**
 *  @brief      This class, BarcodeZebraSsiParam, is a model class used to represent barcode scanning parameters.
 */
@interface BarcodeZebraSsiParam : NSObject

struct ssi_param_t
{
    ZebraSsiParamEnum param;
    NSInteger status;
    NSString *name;
};

@property (nonatomic, assign) NSInteger number;
@property (nonatomic, assign) NSInteger status;
@property (nonatomic, strong) NSString *name;
- (instancetype)initWithNumber:(NSInteger) symbol status:(NSInteger) status name:(NSString *)name;
- (instancetype)initWithStruct:(struct ssi_param_t) ssi_param;
@end

typedef struct ssi_param_t ssi_param_t;

NS_ASSUME_NONNULL_END
