//
//  AsReaderLfDevice.h
//  AsReaderDockSDK
//
//  Created by Mikiko on 11/7/24.
//  Copyright © 2024 SPS INC. All rights reserved.
//

#import "AsReaderDevice.h"

/**
 *  @brief      This is a singleton class that interacts with a Low-Frequency (LF) NFC device. 
 */
@interface AsReaderLfDevice : AsReaderDevice

/**
 *  @brief      AsReaderLfDevice Singleton
 *  @return     AsReaderLfDevice object
 */
+ (instancetype)sharedInstance;

/**
 *  @brief      Read Tags
 *  @details    Start an automatic tag(RFID) read operation, tag IDs are sent back to the user though notification packets.
 *  @param      numberOfTags : Maximum number of tags to read
 *  @param      readUntilInSec : Maximum elapsed time to read tags(sec)
 *  @param      repeatCycle : How many times the reader performs an inventory round
 *  @return     YES
 */
- (BOOL)startScan:(int)numberOfTags
   readUntilInSec:(int)readUntilInSec
      repeatCycle:(int)repeatCycle;

/**
 *  @brief      Stop Reading Tags
 *  @details    Stop an automatic read operation
 *  @return     YES
 */
- (BOOL)stopScan;

@end
